<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for servicePlanOptions StructType
 * @subpackage Structs
 */
class ServicePlanOptions extends AbstractStructBase
{
    /**
     * The servicePlanOptionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $servicePlanOptionId;
    /**
     * The servicePlanOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServicePlanOptionImpl[]
     */
    public $servicePlanOption;
    /**
     * Constructor method for servicePlanOptions
     * @uses ServicePlanOptions::setServicePlanOptionId()
     * @uses ServicePlanOptions::setServicePlanOption()
     * @param string[] $servicePlanOptionId
     * @param \StructType\ServicePlanOptionImpl[] $servicePlanOption
     */
    public function __construct(array $servicePlanOptionId = array(), array $servicePlanOption = array())
    {
        $this
            ->setServicePlanOptionId($servicePlanOptionId)
            ->setServicePlanOption($servicePlanOption);
    }
    /**
     * Get servicePlanOptionId value
     * @return string[]|null
     */
    public function getServicePlanOptionId()
    {
        return $this->servicePlanOptionId;
    }
    /**
     * Set servicePlanOptionId value
     * @throws \InvalidArgumentException
     * @param string[] $servicePlanOptionId
     * @return \StructType\ServicePlanOptions
     */
    public function setServicePlanOptionId(array $servicePlanOptionId = array())
    {
        foreach ($servicePlanOptionId as $servicePlanOptionsServicePlanOptionIdItem) {
            // validation for constraint: itemType
            if (!is_string($servicePlanOptionsServicePlanOptionIdItem)) {
                throw new \InvalidArgumentException(sprintf('The servicePlanOptionId property can only contain items of string, "%s" given', is_object($servicePlanOptionsServicePlanOptionIdItem) ? get_class($servicePlanOptionsServicePlanOptionIdItem) : gettype($servicePlanOptionsServicePlanOptionIdItem)), __LINE__);
            }
        }
        $this->servicePlanOptionId = $servicePlanOptionId;
        return $this;
    }
    /**
     * Add item to servicePlanOptionId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServicePlanOptions
     */
    public function addToServicePlanOptionId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The servicePlanOptionId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->servicePlanOptionId[] = $item;
        return $this;
    }
    /**
     * Get servicePlanOption value
     * @return \StructType\ServicePlanOptionImpl[]|null
     */
    public function getServicePlanOption()
    {
        return $this->servicePlanOption;
    }
    /**
     * Set servicePlanOption value
     * @throws \InvalidArgumentException
     * @param \StructType\ServicePlanOptionImpl[] $servicePlanOption
     * @return \StructType\ServicePlanOptions
     */
    public function setServicePlanOption(array $servicePlanOption = array())
    {
        foreach ($servicePlanOption as $servicePlanOptionsServicePlanOptionItem) {
            // validation for constraint: itemType
            if (!$servicePlanOptionsServicePlanOptionItem instanceof \StructType\ServicePlanOptionImpl) {
                throw new \InvalidArgumentException(sprintf('The servicePlanOption property can only contain items of \StructType\ServicePlanOptionImpl, "%s" given', is_object($servicePlanOptionsServicePlanOptionItem) ? get_class($servicePlanOptionsServicePlanOptionItem) : gettype($servicePlanOptionsServicePlanOptionItem)), __LINE__);
            }
        }
        $this->servicePlanOption = $servicePlanOption;
        return $this;
    }
    /**
     * Add item to servicePlanOption value
     * @throws \InvalidArgumentException
     * @param \StructType\ServicePlanOptionImpl $item
     * @return \StructType\ServicePlanOptions
     */
    public function addToServicePlanOption(\StructType\ServicePlanOptionImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServicePlanOptionImpl) {
            throw new \InvalidArgumentException(sprintf('The servicePlanOption property can only contain items of \StructType\ServicePlanOptionImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->servicePlanOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServicePlanOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
