<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serialNumbers StructType
 * @subpackage Structs
 */
class SerialNumbers extends AbstractStructBase
{
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $item;
    /**
     * Constructor method for serialNumbers
     * @uses SerialNumbers::setItem()
     * @param string[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get item value
     * @return string[]|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @throws \InvalidArgumentException
     * @param string[] $item
     * @return \StructType\SerialNumbers
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $serialNumbersItemItem) {
            // validation for constraint: itemType
            if (!is_string($serialNumbersItemItem)) {
                throw new \InvalidArgumentException(sprintf('The item property can only contain items of string, "%s" given', is_object($serialNumbersItemItem) ? get_class($serialNumbersItemItem) : gettype($serialNumbersItemItem)), __LINE__);
            }
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Add item to item value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SerialNumbers
     */
    public function addToItem($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The item property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SerialNumbers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
