<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchVoucherInventoryRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:searchVoucherInventoryRequestImpl
 * @subpackage Structs
 */
class SearchVoucherInventoryRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The inventoryType
     * @var string
     */
    public $inventoryType;
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * The searchCriteria
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $searchCriteria;
    /**
     * Constructor method for searchVoucherInventoryRequestImpl
     * @uses SearchVoucherInventoryRequestImpl::setInventoryType()
     * @uses SearchVoucherInventoryRequestImpl::setSearchType()
     * @uses SearchVoucherInventoryRequestImpl::setSearchCriteria()
     * @param string $inventoryType
     * @param string $searchType
     * @param string $searchCriteria
     */
    public function __construct($inventoryType = null, $searchType = null, $searchCriteria = null)
    {
        $this
            ->setInventoryType($inventoryType)
            ->setSearchType($searchType)
            ->setSearchCriteria($searchCriteria);
    }
    /**
     * Get inventoryType value
     * @return string|null
     */
    public function getInventoryType()
    {
        return $this->inventoryType;
    }
    /**
     * Set inventoryType value
     * @uses \EnumType\VoucherInventoryTypeEnum::valueIsValid()
     * @uses \EnumType\VoucherInventoryTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $inventoryType
     * @return \StructType\SearchVoucherInventoryRequestImpl
     */
    public function setInventoryType($inventoryType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherInventoryTypeEnum::valueIsValid($inventoryType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $inventoryType, implode(', ', \EnumType\VoucherInventoryTypeEnum::getValidValues())), __LINE__);
        }
        $this->inventoryType = $inventoryType;
        return $this;
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\VoucherOrderSearchTypeEnum::valueIsValid()
     * @uses \EnumType\VoucherOrderSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SearchVoucherInventoryRequestImpl
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherOrderSearchTypeEnum::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\VoucherOrderSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get searchCriteria value
     * @return string|null
     */
    public function getSearchCriteria()
    {
        return $this->searchCriteria;
    }
    /**
     * Set searchCriteria value
     * @param string $searchCriteria
     * @return \StructType\SearchVoucherInventoryRequestImpl
     */
    public function setSearchCriteria($searchCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($searchCriteria) && !is_string($searchCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchCriteria)), __LINE__);
        }
        $this->searchCriteria = $searchCriteria;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchVoucherInventoryRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
