<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchScratchCardActivationStatusRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:searchScratchCardActivationStatusRequestImpl
 * @subpackage Structs
 */
class SearchScratchCardActivationStatusRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * Constructor method for searchScratchCardActivationStatusRequestImpl
     * @uses SearchScratchCardActivationStatusRequestImpl::setSearchType()
     * @uses SearchScratchCardActivationStatusRequestImpl::setValue()
     * @param string $searchType
     * @param string $value
     */
    public function __construct($searchType = null, $value = null)
    {
        $this
            ->setSearchType($searchType)
            ->setValue($value);
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\ScratchCardActivationStatusSearchTypeEnum::valueIsValid()
     * @uses \EnumType\ScratchCardActivationStatusSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SearchScratchCardActivationStatusRequestImpl
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ScratchCardActivationStatusSearchTypeEnum::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\ScratchCardActivationStatusSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\SearchScratchCardActivationStatusRequestImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchScratchCardActivationStatusRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
