<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for scratchCardsDetailEntryImpl StructType
 * @subpackage Structs
 */
class ScratchCardsDetailEntryImpl extends AbstractStructBase
{
    /**
     * The serialNumber
     * @var string
     */
    public $serialNumber;
    /**
     * The distributionType
     * @var string
     */
    public $distributionType;
    /**
     * The activationDate
     * @var string
     */
    public $activationDate;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The balance
     * @var int
     */
    public $balance;
    /**
     * The servicePlan
     * @var string
     */
    public $servicePlan;
    /**
     * The ownerSp
     * @var string
     */
    public $ownerSp;
    /**
     * The firstUseDate
     * @var string
     */
    public $firstUseDate;
    /**
     * The paymentModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentModel;
    /**
     * The batchNumber
     * @var string
     */
    public $batchNumber;
    /**
     * The category
     * @var string
     */
    public $category;
    /**
     * The pinNumber
     * @var string
     */
    public $pinNumber;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The loadingDate
     * @var string
     */
    public $loadingDate;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for scratchCardsDetailEntryImpl
     * @uses ScratchCardsDetailEntryImpl::setSerialNumber()
     * @uses ScratchCardsDetailEntryImpl::setDistributionType()
     * @uses ScratchCardsDetailEntryImpl::setActivationDate()
     * @uses ScratchCardsDetailEntryImpl::setExpirationDate()
     * @uses ScratchCardsDetailEntryImpl::setBalance()
     * @uses ScratchCardsDetailEntryImpl::setServicePlan()
     * @uses ScratchCardsDetailEntryImpl::setOwnerSp()
     * @uses ScratchCardsDetailEntryImpl::setFirstUseDate()
     * @uses ScratchCardsDetailEntryImpl::setPaymentModel()
     * @uses ScratchCardsDetailEntryImpl::setBatchNumber()
     * @uses ScratchCardsDetailEntryImpl::setCategory()
     * @uses ScratchCardsDetailEntryImpl::setPinNumber()
     * @uses ScratchCardsDetailEntryImpl::setValue()
     * @uses ScratchCardsDetailEntryImpl::setLoadingDate()
     * @uses ScratchCardsDetailEntryImpl::setStatus()
     * @param string $serialNumber
     * @param string $distributionType
     * @param string $activationDate
     * @param string $expirationDate
     * @param int $balance
     * @param string $servicePlan
     * @param string $ownerSp
     * @param string $firstUseDate
     * @param string $paymentModel
     * @param string $batchNumber
     * @param string $category
     * @param string $pinNumber
     * @param string $value
     * @param string $loadingDate
     * @param string $status
     */
    public function __construct($serialNumber = null, $distributionType = null, $activationDate = null, $expirationDate = null, $balance = null, $servicePlan = null, $ownerSp = null, $firstUseDate = null, $paymentModel = null, $batchNumber = null, $category = null, $pinNumber = null, $value = null, $loadingDate = null, $status = null)
    {
        $this
            ->setSerialNumber($serialNumber)
            ->setDistributionType($distributionType)
            ->setActivationDate($activationDate)
            ->setExpirationDate($expirationDate)
            ->setBalance($balance)
            ->setServicePlan($servicePlan)
            ->setOwnerSp($ownerSp)
            ->setFirstUseDate($firstUseDate)
            ->setPaymentModel($paymentModel)
            ->setBatchNumber($batchNumber)
            ->setCategory($category)
            ->setPinNumber($pinNumber)
            ->setValue($value)
            ->setLoadingDate($loadingDate)
            ->setStatus($status);
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get distributionType value
     * @return string|null
     */
    public function getDistributionType()
    {
        return $this->distributionType;
    }
    /**
     * Set distributionType value
     * @param string $distributionType
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setDistributionType($distributionType = null)
    {
        // validation for constraint: string
        if (!is_null($distributionType) && !is_string($distributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionType)), __LINE__);
        }
        $this->distributionType = $distributionType;
        return $this;
    }
    /**
     * Get activationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->activationDate;
    }
    /**
     * Set activationDate value
     * @param string $activationDate
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationDate)), __LINE__);
        }
        $this->activationDate = $activationDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get balance value
     * @return int|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param int $balance
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: int
        if (!is_null($balance) && !is_numeric($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get servicePlan value
     * @return string|null
     */
    public function getServicePlan()
    {
        return $this->servicePlan;
    }
    /**
     * Set servicePlan value
     * @param string $servicePlan
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setServicePlan($servicePlan = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlan) && !is_string($servicePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlan)), __LINE__);
        }
        $this->servicePlan = $servicePlan;
        return $this;
    }
    /**
     * Get ownerSp value
     * @return string|null
     */
    public function getOwnerSp()
    {
        return $this->ownerSp;
    }
    /**
     * Set ownerSp value
     * @param string $ownerSp
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setOwnerSp($ownerSp = null)
    {
        // validation for constraint: string
        if (!is_null($ownerSp) && !is_string($ownerSp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownerSp)), __LINE__);
        }
        $this->ownerSp = $ownerSp;
        return $this;
    }
    /**
     * Get firstUseDate value
     * @return string|null
     */
    public function getFirstUseDate()
    {
        return $this->firstUseDate;
    }
    /**
     * Set firstUseDate value
     * @param string $firstUseDate
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setFirstUseDate($firstUseDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstUseDate) && !is_string($firstUseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstUseDate)), __LINE__);
        }
        $this->firstUseDate = $firstUseDate;
        return $this;
    }
    /**
     * Get paymentModel value
     * @return string|null
     */
    public function getPaymentModel()
    {
        return $this->paymentModel;
    }
    /**
     * Set paymentModel value
     * @param string $paymentModel
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setPaymentModel($paymentModel = null)
    {
        // validation for constraint: string
        if (!is_null($paymentModel) && !is_string($paymentModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentModel)), __LINE__);
        }
        $this->paymentModel = $paymentModel;
        return $this;
    }
    /**
     * Get batchNumber value
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->batchNumber;
    }
    /**
     * Set batchNumber value
     * @param string $batchNumber
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setBatchNumber($batchNumber = null)
    {
        // validation for constraint: string
        if (!is_null($batchNumber) && !is_string($batchNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batchNumber)), __LINE__);
        }
        $this->batchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get pinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->pinNumber;
    }
    /**
     * Set pinNumber value
     * @param string $pinNumber
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinNumber)), __LINE__);
        }
        $this->pinNumber = $pinNumber;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get loadingDate value
     * @return string|null
     */
    public function getLoadingDate()
    {
        return $this->loadingDate;
    }
    /**
     * Set loadingDate value
     * @param string $loadingDate
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setLoadingDate($loadingDate = null)
    {
        // validation for constraint: string
        if (!is_null($loadingDate) && !is_string($loadingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loadingDate)), __LINE__);
        }
        $this->loadingDate = $loadingDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScratchCardsDetailEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
