<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for scratchCardDetailsImpl StructType
 * @subpackage Structs
 */
class ScratchCardDetailsImpl extends DeviceDetailsImpl
{
    /**
     * The spAccountNumber
     * @var string
     */
    public $spAccountNumber;
    /**
     * The spName
     * @var string
     */
    public $spName;
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The accountStatus
     * @var string
     */
    public $accountStatus;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The purchaseOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseOrder;
    /**
     * The serialNumber
     * @var string
     */
    public $serialNumber;
    /**
     * The pin
     * @var string
     */
    public $pin;
    /**
     * The initialBalance
     * @var int
     */
    public $initialBalance;
    /**
     * The currentBalance
     * @var int
     */
    public $currentBalance;
    /**
     * The activationDate
     * @var string
     */
    public $activationDate;
    /**
     * The firstUseDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstUseDate;
    /**
     * The expirationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The voucherStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $voucherStatus;
    /**
     * The activities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Activities
     */
    public $activities;
    /**
     * Constructor method for scratchCardDetailsImpl
     * @uses ScratchCardDetailsImpl::setSpAccountNumber()
     * @uses ScratchCardDetailsImpl::setSpName()
     * @uses ScratchCardDetailsImpl::setAccountNumber()
     * @uses ScratchCardDetailsImpl::setAccountStatus()
     * @uses ScratchCardDetailsImpl::setType()
     * @uses ScratchCardDetailsImpl::setPurchaseOrder()
     * @uses ScratchCardDetailsImpl::setSerialNumber()
     * @uses ScratchCardDetailsImpl::setPin()
     * @uses ScratchCardDetailsImpl::setInitialBalance()
     * @uses ScratchCardDetailsImpl::setCurrentBalance()
     * @uses ScratchCardDetailsImpl::setActivationDate()
     * @uses ScratchCardDetailsImpl::setFirstUseDate()
     * @uses ScratchCardDetailsImpl::setExpirationDate()
     * @uses ScratchCardDetailsImpl::setVoucherStatus()
     * @uses ScratchCardDetailsImpl::setActivities()
     * @param string $spAccountNumber
     * @param string $spName
     * @param string $accountNumber
     * @param string $accountStatus
     * @param string $type
     * @param string $purchaseOrder
     * @param string $serialNumber
     * @param string $pin
     * @param int $initialBalance
     * @param int $currentBalance
     * @param string $activationDate
     * @param string $firstUseDate
     * @param string $expirationDate
     * @param string $voucherStatus
     * @param \StructType\Activities $activities
     */
    public function __construct($spAccountNumber = null, $spName = null, $accountNumber = null, $accountStatus = null, $type = null, $purchaseOrder = null, $serialNumber = null, $pin = null, $initialBalance = null, $currentBalance = null, $activationDate = null, $firstUseDate = null, $expirationDate = null, $voucherStatus = null, \StructType\Activities $activities = null)
    {
        $this
            ->setSpAccountNumber($spAccountNumber)
            ->setSpName($spName)
            ->setAccountNumber($accountNumber)
            ->setAccountStatus($accountStatus)
            ->setType($type)
            ->setPurchaseOrder($purchaseOrder)
            ->setSerialNumber($serialNumber)
            ->setPin($pin)
            ->setInitialBalance($initialBalance)
            ->setCurrentBalance($currentBalance)
            ->setActivationDate($activationDate)
            ->setFirstUseDate($firstUseDate)
            ->setExpirationDate($expirationDate)
            ->setVoucherStatus($voucherStatus)
            ->setActivities($activities);
    }
    /**
     * Get spAccountNumber value
     * @return string|null
     */
    public function getSpAccountNumber()
    {
        return $this->spAccountNumber;
    }
    /**
     * Set spAccountNumber value
     * @param string $spAccountNumber
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setSpAccountNumber($spAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($spAccountNumber) && !is_string($spAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spAccountNumber)), __LINE__);
        }
        $this->spAccountNumber = $spAccountNumber;
        return $this;
    }
    /**
     * Get spName value
     * @return string|null
     */
    public function getSpName()
    {
        return $this->spName;
    }
    /**
     * Set spName value
     * @param string $spName
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setSpName($spName = null)
    {
        // validation for constraint: string
        if (!is_null($spName) && !is_string($spName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spName)), __LINE__);
        }
        $this->spName = $spName;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountStatus, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return string|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param string $purchaseOrder
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setPurchaseOrder($purchaseOrder = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrder) && !is_string($purchaseOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseOrder)), __LINE__);
        }
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @param string $pin
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setPin($pin = null)
    {
        // validation for constraint: string
        if (!is_null($pin) && !is_string($pin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pin)), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get initialBalance value
     * @return int|null
     */
    public function getInitialBalance()
    {
        return $this->initialBalance;
    }
    /**
     * Set initialBalance value
     * @param int $initialBalance
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setInitialBalance($initialBalance = null)
    {
        // validation for constraint: int
        if (!is_null($initialBalance) && !is_numeric($initialBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($initialBalance)), __LINE__);
        }
        $this->initialBalance = $initialBalance;
        return $this;
    }
    /**
     * Get currentBalance value
     * @return int|null
     */
    public function getCurrentBalance()
    {
        return $this->currentBalance;
    }
    /**
     * Set currentBalance value
     * @param int $currentBalance
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setCurrentBalance($currentBalance = null)
    {
        // validation for constraint: int
        if (!is_null($currentBalance) && !is_numeric($currentBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentBalance)), __LINE__);
        }
        $this->currentBalance = $currentBalance;
        return $this;
    }
    /**
     * Get activationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->activationDate;
    }
    /**
     * Set activationDate value
     * @param string $activationDate
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationDate)), __LINE__);
        }
        $this->activationDate = $activationDate;
        return $this;
    }
    /**
     * Get firstUseDate value
     * @return string|null
     */
    public function getFirstUseDate()
    {
        return $this->firstUseDate;
    }
    /**
     * Set firstUseDate value
     * @param string $firstUseDate
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setFirstUseDate($firstUseDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstUseDate) && !is_string($firstUseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstUseDate)), __LINE__);
        }
        $this->firstUseDate = $firstUseDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get voucherStatus value
     * @return string|null
     */
    public function getVoucherStatus()
    {
        return $this->voucherStatus;
    }
    /**
     * Set voucherStatus value
     * @param string $voucherStatus
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setVoucherStatus($voucherStatus = null)
    {
        // validation for constraint: string
        if (!is_null($voucherStatus) && !is_string($voucherStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voucherStatus)), __LINE__);
        }
        $this->voucherStatus = $voucherStatus;
        return $this;
    }
    /**
     * Get activities value
     * @return \StructType\Activities|null
     */
    public function getActivities()
    {
        return $this->activities;
    }
    /**
     * Set activities value
     * @param \StructType\Activities $activities
     * @return \StructType\ScratchCardDetailsImpl
     */
    public function setActivities(\StructType\Activities $activities = null)
    {
        $this->activities = $activities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScratchCardDetailsImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
