<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for scratchCardActivationStatusImpl StructType
 * @subpackage Structs
 */
class ScratchCardActivationStatusImpl extends AbstractStructBase
{
    /**
     * The requestId
     * @var string
     */
    public $requestId;
    /**
     * The purchaseOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseOrder;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The startSerial
     * @var string
     */
    public $startSerial;
    /**
     * The endSerial
     * @var string
     */
    public $endSerial;
    /**
     * The requestTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestTimestamp;
    /**
     * The totalRequested
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalRequested;
    /**
     * Constructor method for scratchCardActivationStatusImpl
     * @uses ScratchCardActivationStatusImpl::setRequestId()
     * @uses ScratchCardActivationStatusImpl::setPurchaseOrder()
     * @uses ScratchCardActivationStatusImpl::setStatus()
     * @uses ScratchCardActivationStatusImpl::setType()
     * @uses ScratchCardActivationStatusImpl::setStartSerial()
     * @uses ScratchCardActivationStatusImpl::setEndSerial()
     * @uses ScratchCardActivationStatusImpl::setRequestTimestamp()
     * @uses ScratchCardActivationStatusImpl::setTotalRequested()
     * @param string $requestId
     * @param string $purchaseOrder
     * @param string $status
     * @param string $type
     * @param string $startSerial
     * @param string $endSerial
     * @param string $requestTimestamp
     * @param int $totalRequested
     */
    public function __construct($requestId = null, $purchaseOrder = null, $status = null, $type = null, $startSerial = null, $endSerial = null, $requestTimestamp = null, $totalRequested = null)
    {
        $this
            ->setRequestId($requestId)
            ->setPurchaseOrder($purchaseOrder)
            ->setStatus($status)
            ->setType($type)
            ->setStartSerial($startSerial)
            ->setEndSerial($endSerial)
            ->setRequestTimestamp($requestTimestamp)
            ->setTotalRequested($totalRequested);
    }
    /**
     * Get requestId value
     * @return string|null
     */
    public function getRequestId()
    {
        return $this->requestId;
    }
    /**
     * Set requestId value
     * @param string $requestId
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestId)), __LINE__);
        }
        $this->requestId = $requestId;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return string|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param string $purchaseOrder
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setPurchaseOrder($purchaseOrder = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrder) && !is_string($purchaseOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseOrder)), __LINE__);
        }
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ActivationStatusEnum::valueIsValid()
     * @uses \EnumType\ActivationStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivationStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ActivationStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ActivationTypeEnum::valueIsValid()
     * @uses \EnumType\ActivationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivationTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivationTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get startSerial value
     * @return string|null
     */
    public function getStartSerial()
    {
        return $this->startSerial;
    }
    /**
     * Set startSerial value
     * @param string $startSerial
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setStartSerial($startSerial = null)
    {
        // validation for constraint: string
        if (!is_null($startSerial) && !is_string($startSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startSerial)), __LINE__);
        }
        $this->startSerial = $startSerial;
        return $this;
    }
    /**
     * Get endSerial value
     * @return string|null
     */
    public function getEndSerial()
    {
        return $this->endSerial;
    }
    /**
     * Set endSerial value
     * @param string $endSerial
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setEndSerial($endSerial = null)
    {
        // validation for constraint: string
        if (!is_null($endSerial) && !is_string($endSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endSerial)), __LINE__);
        }
        $this->endSerial = $endSerial;
        return $this;
    }
    /**
     * Get requestTimestamp value
     * @return string|null
     */
    public function getRequestTimestamp()
    {
        return $this->requestTimestamp;
    }
    /**
     * Set requestTimestamp value
     * @param string $requestTimestamp
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setRequestTimestamp($requestTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($requestTimestamp) && !is_string($requestTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestTimestamp)), __LINE__);
        }
        $this->requestTimestamp = $requestTimestamp;
        return $this;
    }
    /**
     * Get totalRequested value
     * @return int|null
     */
    public function getTotalRequested()
    {
        return $this->totalRequested;
    }
    /**
     * Set totalRequested value
     * @param int $totalRequested
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public function setTotalRequested($totalRequested = null)
    {
        // validation for constraint: int
        if (!is_null($totalRequested) && !is_numeric($totalRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRequested)), __LINE__);
        }
        $this->totalRequested = $totalRequested;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ScratchCardActivationStatusImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
