<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdDestinationSearchReplaceEntryImpl StructType
 * @subpackage Structs
 */
class SbdDestinationSearchReplaceEntryImpl extends AbstractStructBase
{
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The deliveryMethod
     * @var string
     */
    public $deliveryMethod;
    /**
     * The newDeliveryMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $newDeliveryMethod;
    /**
     * The oldValue
     * @var string
     */
    public $oldValue;
    /**
     * The newValue
     * @var string
     */
    public $newValue;
    /**
     * The result
     * @var string
     */
    public $result;
    /**
     * Constructor method for sbdDestinationSearchReplaceEntryImpl
     * @uses SbdDestinationSearchReplaceEntryImpl::setImei()
     * @uses SbdDestinationSearchReplaceEntryImpl::setStatus()
     * @uses SbdDestinationSearchReplaceEntryImpl::setDeliveryMethod()
     * @uses SbdDestinationSearchReplaceEntryImpl::setNewDeliveryMethod()
     * @uses SbdDestinationSearchReplaceEntryImpl::setOldValue()
     * @uses SbdDestinationSearchReplaceEntryImpl::setNewValue()
     * @uses SbdDestinationSearchReplaceEntryImpl::setResult()
     * @param string $imei
     * @param string $status
     * @param string $deliveryMethod
     * @param string $newDeliveryMethod
     * @param string $oldValue
     * @param string $newValue
     * @param string $result
     */
    public function __construct($imei = null, $status = null, $deliveryMethod = null, $newDeliveryMethod = null, $oldValue = null, $newValue = null, $result = null)
    {
        $this
            ->setImei($imei)
            ->setStatus($status)
            ->setDeliveryMethod($deliveryMethod)
            ->setNewDeliveryMethod($newDeliveryMethod)
            ->setOldValue($oldValue)
            ->setNewValue($newValue)
            ->setResult($result);
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethod
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethod, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get newDeliveryMethod value
     * @return string|null
     */
    public function getNewDeliveryMethod()
    {
        return $this->newDeliveryMethod;
    }
    /**
     * Set newDeliveryMethod value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newDeliveryMethod
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setNewDeliveryMethod($newDeliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($newDeliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $newDeliveryMethod, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->newDeliveryMethod = $newDeliveryMethod;
        return $this;
    }
    /**
     * Get oldValue value
     * @return string|null
     */
    public function getOldValue()
    {
        return $this->oldValue;
    }
    /**
     * Set oldValue value
     * @param string $oldValue
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldValue)), __LINE__);
        }
        $this->oldValue = $oldValue;
        return $this;
    }
    /**
     * Get newValue value
     * @return string|null
     */
    public function getNewValue()
    {
        return $this->newValue;
    }
    /**
     * Set newValue value
     * @param string $newValue
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newValue)), __LINE__);
        }
        $this->newValue = $newValue;
        return $this;
    }
    /**
     * Get result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @uses \EnumType\SbdDestSearchAndReplaceResultTypeEnum::valueIsValid()
     * @uses \EnumType\SbdDestSearchAndReplaceResultTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $result
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public function setResult($result = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdDestSearchAndReplaceResultTypeEnum::valueIsValid($result)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $result, implode(', ', \EnumType\SbdDestSearchAndReplaceResultTypeEnum::getValidValues())), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdDestinationSearchReplaceEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
