<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pttDeviceDetailImpl StructType
 * @subpackage Structs
 */
class PttDeviceDetailImpl extends AbstractStructBase
{
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractId;
    /**
     * The imei
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $imei;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The activationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activationDate;
    /**
     * Constructor method for pttDeviceDetailImpl
     * @uses PttDeviceDetailImpl::setContractId()
     * @uses PttDeviceDetailImpl::setImei()
     * @uses PttDeviceDetailImpl::setDescription()
     * @uses PttDeviceDetailImpl::setStatus()
     * @uses PttDeviceDetailImpl::setActivationDate()
     * @param string $contractId
     * @param string $imei
     * @param string $description
     * @param string $status
     * @param string $activationDate
     */
    public function __construct($contractId = null, $imei = null, $description = null, $status = null, $activationDate = null)
    {
        $this
            ->setContractId($contractId)
            ->setImei($imei)
            ->setDescription($description)
            ->setStatus($status)
            ->setActivationDate($activationDate);
    }
    /**
     * Get contractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param string $contractId
     * @return \StructType\PttDeviceDetailImpl
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\PttDeviceDetailImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\PttDeviceDetailImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PttDeviceDetailImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get activationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->activationDate;
    }
    /**
     * Set activationDate value
     * @param string $activationDate
     * @return \StructType\PttDeviceDetailImpl
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationDate)), __LINE__);
        }
        $this->activationDate = $activationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PttDeviceDetailImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
