<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prepaidAccountDetailImpl StructType
 * @subpackage Structs
 */
class PrepaidAccountDetailImpl extends AbstractStructBase
{
    /**
     * The msisdn
     * @var string
     */
    public $msisdn;
    /**
     * The iccid
     * @var string
     */
    public $iccid;
    /**
     * The createdBy
     * @var string
     */
    public $createdBy;
    /**
     * The createdDate
     * @var string
     */
    public $createdDate;
    /**
     * The expirationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expirationDate;
    /**
     * The lockState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lockState;
    /**
     * The pinNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pinNumber;
    /**
     * The currentBalance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $currentBalance;
    /**
     * The servicePlan
     * @var string
     */
    public $servicePlan;
    /**
     * The restrictScratchCards
     * @var bool
     */
    public $restrictScratchCards;
    /**
     * The spAlert
     * @var bool
     */
    public $spAlert;
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * The accountNo
     * @var string
     */
    public $accountNo;
    /**
     * The isuFlag
     * @var bool
     */
    public $isuFlag;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The unitExpiration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitExpiration;
    /**
     * The unitExpirationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitExpirationDate;
    /**
     * The unitExpirationNotice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitExpirationNotice;
    /**
     * Constructor method for prepaidAccountDetailImpl
     * @uses PrepaidAccountDetailImpl::setMsisdn()
     * @uses PrepaidAccountDetailImpl::setIccid()
     * @uses PrepaidAccountDetailImpl::setCreatedBy()
     * @uses PrepaidAccountDetailImpl::setCreatedDate()
     * @uses PrepaidAccountDetailImpl::setExpirationDate()
     * @uses PrepaidAccountDetailImpl::setLockState()
     * @uses PrepaidAccountDetailImpl::setPinNumber()
     * @uses PrepaidAccountDetailImpl::setCurrentBalance()
     * @uses PrepaidAccountDetailImpl::setServicePlan()
     * @uses PrepaidAccountDetailImpl::setRestrictScratchCards()
     * @uses PrepaidAccountDetailImpl::setSpAlert()
     * @uses PrepaidAccountDetailImpl::setLanguage()
     * @uses PrepaidAccountDetailImpl::setAccountNo()
     * @uses PrepaidAccountDetailImpl::setIsuFlag()
     * @uses PrepaidAccountDetailImpl::setStatus()
     * @uses PrepaidAccountDetailImpl::setUnitExpiration()
     * @uses PrepaidAccountDetailImpl::setUnitExpirationDate()
     * @uses PrepaidAccountDetailImpl::setUnitExpirationNotice()
     * @param string $msisdn
     * @param string $iccid
     * @param string $createdBy
     * @param string $createdDate
     * @param string $expirationDate
     * @param string $lockState
     * @param string $pinNumber
     * @param int $currentBalance
     * @param string $servicePlan
     * @param bool $restrictScratchCards
     * @param bool $spAlert
     * @param string $language
     * @param string $accountNo
     * @param bool $isuFlag
     * @param string $status
     * @param string $unitExpiration
     * @param string $unitExpirationDate
     * @param string $unitExpirationNotice
     */
    public function __construct($msisdn = null, $iccid = null, $createdBy = null, $createdDate = null, $expirationDate = null, $lockState = null, $pinNumber = null, $currentBalance = null, $servicePlan = null, $restrictScratchCards = null, $spAlert = null, $language = null, $accountNo = null, $isuFlag = null, $status = null, $unitExpiration = null, $unitExpirationDate = null, $unitExpirationNotice = null)
    {
        $this
            ->setMsisdn($msisdn)
            ->setIccid($iccid)
            ->setCreatedBy($createdBy)
            ->setCreatedDate($createdDate)
            ->setExpirationDate($expirationDate)
            ->setLockState($lockState)
            ->setPinNumber($pinNumber)
            ->setCurrentBalance($currentBalance)
            ->setServicePlan($servicePlan)
            ->setRestrictScratchCards($restrictScratchCards)
            ->setSpAlert($spAlert)
            ->setLanguage($language)
            ->setAccountNo($accountNo)
            ->setIsuFlag($isuFlag)
            ->setStatus($status)
            ->setUnitExpiration($unitExpiration)
            ->setUnitExpirationDate($unitExpirationDate)
            ->setUnitExpirationNotice($unitExpirationNotice);
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get iccid value
     * @return string|null
     */
    public function getIccid()
    {
        return $this->iccid;
    }
    /**
     * Set iccid value
     * @param string $iccid
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setIccid($iccid = null)
    {
        // validation for constraint: string
        if (!is_null($iccid) && !is_string($iccid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iccid)), __LINE__);
        }
        $this->iccid = $iccid;
        return $this;
    }
    /**
     * Get createdBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }
    /**
     * Set createdBy value
     * @param string $createdBy
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->createdBy = $createdBy;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get lockState value
     * @return string|null
     */
    public function getLockState()
    {
        return $this->lockState;
    }
    /**
     * Set lockState value
     * @param string $lockState
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setLockState($lockState = null)
    {
        // validation for constraint: string
        if (!is_null($lockState) && !is_string($lockState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lockState)), __LINE__);
        }
        $this->lockState = $lockState;
        return $this;
    }
    /**
     * Get pinNumber value
     * @return string|null
     */
    public function getPinNumber()
    {
        return $this->pinNumber;
    }
    /**
     * Set pinNumber value
     * @param string $pinNumber
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setPinNumber($pinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($pinNumber) && !is_string($pinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pinNumber)), __LINE__);
        }
        $this->pinNumber = $pinNumber;
        return $this;
    }
    /**
     * Get currentBalance value
     * @return int|null
     */
    public function getCurrentBalance()
    {
        return $this->currentBalance;
    }
    /**
     * Set currentBalance value
     * @param int $currentBalance
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setCurrentBalance($currentBalance = null)
    {
        // validation for constraint: int
        if (!is_null($currentBalance) && !is_numeric($currentBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentBalance)), __LINE__);
        }
        $this->currentBalance = $currentBalance;
        return $this;
    }
    /**
     * Get servicePlan value
     * @return string|null
     */
    public function getServicePlan()
    {
        return $this->servicePlan;
    }
    /**
     * Set servicePlan value
     * @param string $servicePlan
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setServicePlan($servicePlan = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlan) && !is_string($servicePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlan)), __LINE__);
        }
        $this->servicePlan = $servicePlan;
        return $this;
    }
    /**
     * Get restrictScratchCards value
     * @return bool|null
     */
    public function getRestrictScratchCards()
    {
        return $this->restrictScratchCards;
    }
    /**
     * Set restrictScratchCards value
     * @param bool $restrictScratchCards
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setRestrictScratchCards($restrictScratchCards = null)
    {
        $this->restrictScratchCards = $restrictScratchCards;
        return $this;
    }
    /**
     * Get spAlert value
     * @return bool|null
     */
    public function getSpAlert()
    {
        return $this->spAlert;
    }
    /**
     * Set spAlert value
     * @param bool $spAlert
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setSpAlert($spAlert = null)
    {
        $this->spAlert = $spAlert;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\PrepaidLanguageTypeEnum::valueIsValid()
     * @uses \EnumType\PrepaidLanguageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrepaidLanguageTypeEnum::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \EnumType\PrepaidLanguageTypeEnum::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get accountNo value
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->accountNo;
    }
    /**
     * Set accountNo value
     * @param string $accountNo
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNo)), __LINE__);
        }
        $this->accountNo = $accountNo;
        return $this;
    }
    /**
     * Get isuFlag value
     * @return bool|null
     */
    public function getIsuFlag()
    {
        return $this->isuFlag;
    }
    /**
     * Set isuFlag value
     * @param bool $isuFlag
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setIsuFlag($isuFlag = null)
    {
        $this->isuFlag = $isuFlag;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get unitExpiration value
     * @return string|null
     */
    public function getUnitExpiration()
    {
        return $this->unitExpiration;
    }
    /**
     * Set unitExpiration value
     * @param string $unitExpiration
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setUnitExpiration($unitExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($unitExpiration) && !is_string($unitExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitExpiration)), __LINE__);
        }
        $this->unitExpiration = $unitExpiration;
        return $this;
    }
    /**
     * Get unitExpirationDate value
     * @return string|null
     */
    public function getUnitExpirationDate()
    {
        return $this->unitExpirationDate;
    }
    /**
     * Set unitExpirationDate value
     * @param string $unitExpirationDate
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setUnitExpirationDate($unitExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($unitExpirationDate) && !is_string($unitExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitExpirationDate)), __LINE__);
        }
        $this->unitExpirationDate = $unitExpirationDate;
        return $this;
    }
    /**
     * Get unitExpirationNotice value
     * @return string|null
     */
    public function getUnitExpirationNotice()
    {
        return $this->unitExpirationNotice;
    }
    /**
     * Set unitExpirationNotice value
     * @param string $unitExpirationNotice
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public function setUnitExpirationNotice($unitExpirationNotice = null)
    {
        // validation for constraint: string
        if (!is_null($unitExpirationNotice) && !is_string($unitExpirationNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitExpirationNotice)), __LINE__);
        }
        $this->unitExpirationNotice = $unitExpirationNotice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepaidAccountDetailImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
