<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for outageScheduleItemImpl StructType
 * @subpackage Structs
 */
class OutageScheduleItemImpl extends AbstractStructBase
{
    /**
     * The startTime
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * @var string
     */
    public $endTime;
    /**
     * The duration
     * @var int
     */
    public $duration;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The affectedElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AffectedElements
     */
    public $affectedElements;
    /**
     * The emergency
     * @var bool
     */
    public $emergency;
    /**
     * Constructor method for outageScheduleItemImpl
     * @uses OutageScheduleItemImpl::setStartTime()
     * @uses OutageScheduleItemImpl::setEndTime()
     * @uses OutageScheduleItemImpl::setDuration()
     * @uses OutageScheduleItemImpl::setName()
     * @uses OutageScheduleItemImpl::setServiceType()
     * @uses OutageScheduleItemImpl::setDescription()
     * @uses OutageScheduleItemImpl::setAffectedElements()
     * @uses OutageScheduleItemImpl::setEmergency()
     * @param string $startTime
     * @param string $endTime
     * @param int $duration
     * @param string $name
     * @param string $serviceType
     * @param string $description
     * @param \StructType\AffectedElements $affectedElements
     * @param bool $emergency
     */
    public function __construct($startTime = null, $endTime = null, $duration = null, $name = null, $serviceType = null, $description = null, \StructType\AffectedElements $affectedElements = null, $emergency = null)
    {
        $this
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setDuration($duration)
            ->setName($name)
            ->setServiceType($serviceType)
            ->setDescription($description)
            ->setAffectedElements($affectedElements)
            ->setEmergency($emergency);
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param string $startTime
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get affectedElements value
     * @return \StructType\AffectedElements|null
     */
    public function getAffectedElements()
    {
        return $this->affectedElements;
    }
    /**
     * Set affectedElements value
     * @param \StructType\AffectedElements $affectedElements
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setAffectedElements(\StructType\AffectedElements $affectedElements = null)
    {
        $this->affectedElements = $affectedElements;
        return $this;
    }
    /**
     * Get emergency value
     * @return bool|null
     */
    public function getEmergency()
    {
        return $this->emergency;
    }
    /**
     * Set emergency value
     * @param bool $emergency
     * @return \StructType\OutageScheduleItemImpl
     */
    public function setEmergency($emergency = null)
    {
        $this->emergency = $emergency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutageScheduleItemImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
