<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orders StructType
 * @subpackage Structs
 */
class Orders extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VoucherOrderImpl[]
     */
    public $order;
    /**
     * Constructor method for orders
     * @uses Orders::setOrder()
     * @param \StructType\VoucherOrderImpl[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \StructType\VoucherOrderImpl[]|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherOrderImpl[] $order
     * @return \StructType\Orders
     */
    public function setOrder(array $order = array())
    {
        foreach ($order as $ordersOrderItem) {
            // validation for constraint: itemType
            if (!$ordersOrderItem instanceof \StructType\VoucherOrderImpl) {
                throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\VoucherOrderImpl, "%s" given', is_object($ordersOrderItem) ? get_class($ordersOrderItem) : gettype($ordersOrderItem)), __LINE__);
            }
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherOrderImpl $item
     * @return \StructType\Orders
     */
    public function addToOrder(\StructType\VoucherOrderImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VoucherOrderImpl) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of \StructType\VoucherOrderImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Orders
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
