<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for modelImpl StructType
 * @subpackage Structs
 */
class ModelImpl extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The vertical
     * @var string
     */
    public $vertical;
    /**
     * The manufacturer
     * @var string
     */
    public $manufacturer;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The modelNumber
     * @var string
     */
    public $modelNumber;
    /**
     * The sbdCapable
     * @var string
     */
    public $sbdCapable;
    /**
     * The pttCapable
     * @var string
     */
    public $pttCapable;
    /**
     * The burstCapable
     * @var string
     */
    public $burstCapable;
    /**
     * The opCapable
     * @var string
     */
    public $opCapable;
    /**
     * The telCapable
     * @var string
     */
    public $telCapable;
    /**
     * The certusVoiceCapable
     * @var string
     */
    public $certusVoiceCapable;
    /**
     * The geocastCapable
     * @var string
     */
    public $geocastCapable;
    /**
     * The streamingCapable
     * @var string
     */
    public $streamingCapable;
    /**
     * The maxStreamingSpd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $maxStreamingSpd;
    /**
     * The maxDataSpeed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxDataSpeed;
    /**
     * The serviceCat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceCat;
    /**
     * The serviceClass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceClass;
    /**
     * The classmark
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $classmark;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The certT
     * @var string
     */
    public $certT;
    /**
     * The certBy
     * @var string
     */
    public $certBy;
    /**
     * The safetyCapable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $safetyCapable;
    /**
     * The seClassMark
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seClassMark;
    /**
     * The maxB1Spd
     * @var int
     */
    public $maxB1Spd;
    /**
     * The maxNextSpd
     * @var int
     */
    public $maxNextSpd;
    /**
     * The c8ModCod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $c8ModCod;
    /**
     * Constructor method for modelImpl
     * @uses ModelImpl::setId()
     * @uses ModelImpl::setVertical()
     * @uses ModelImpl::setManufacturer()
     * @uses ModelImpl::setName()
     * @uses ModelImpl::setModelNumber()
     * @uses ModelImpl::setSbdCapable()
     * @uses ModelImpl::setPttCapable()
     * @uses ModelImpl::setBurstCapable()
     * @uses ModelImpl::setOpCapable()
     * @uses ModelImpl::setTelCapable()
     * @uses ModelImpl::setCertusVoiceCapable()
     * @uses ModelImpl::setGeocastCapable()
     * @uses ModelImpl::setStreamingCapable()
     * @uses ModelImpl::setMaxStreamingSpd()
     * @uses ModelImpl::setMaxDataSpeed()
     * @uses ModelImpl::setServiceCat()
     * @uses ModelImpl::setServiceClass()
     * @uses ModelImpl::setClassmark()
     * @uses ModelImpl::setStatus()
     * @uses ModelImpl::setCertT()
     * @uses ModelImpl::setCertBy()
     * @uses ModelImpl::setSafetyCapable()
     * @uses ModelImpl::setSeClassMark()
     * @uses ModelImpl::setMaxB1Spd()
     * @uses ModelImpl::setMaxNextSpd()
     * @uses ModelImpl::setC8ModCod()
     * @param string $id
     * @param string $vertical
     * @param string $manufacturer
     * @param string $name
     * @param string $modelNumber
     * @param string $sbdCapable
     * @param string $pttCapable
     * @param string $burstCapable
     * @param string $opCapable
     * @param string $telCapable
     * @param string $certusVoiceCapable
     * @param string $geocastCapable
     * @param string $streamingCapable
     * @param string $maxStreamingSpd
     * @param int $maxDataSpeed
     * @param string $serviceCat
     * @param string $serviceClass
     * @param string $classmark
     * @param string $status
     * @param string $certT
     * @param string $certBy
     * @param string $safetyCapable
     * @param string $seClassMark
     * @param int $maxB1Spd
     * @param int $maxNextSpd
     * @param string $c8ModCod
     */
    public function __construct($id = null, $vertical = null, $manufacturer = null, $name = null, $modelNumber = null, $sbdCapable = null, $pttCapable = null, $burstCapable = null, $opCapable = null, $telCapable = null, $certusVoiceCapable = null, $geocastCapable = null, $streamingCapable = null, $maxStreamingSpd = null, $maxDataSpeed = null, $serviceCat = null, $serviceClass = null, $classmark = null, $status = null, $certT = null, $certBy = null, $safetyCapable = null, $seClassMark = null, $maxB1Spd = null, $maxNextSpd = null, $c8ModCod = null)
    {
        $this
            ->setId($id)
            ->setVertical($vertical)
            ->setManufacturer($manufacturer)
            ->setName($name)
            ->setModelNumber($modelNumber)
            ->setSbdCapable($sbdCapable)
            ->setPttCapable($pttCapable)
            ->setBurstCapable($burstCapable)
            ->setOpCapable($opCapable)
            ->setTelCapable($telCapable)
            ->setCertusVoiceCapable($certusVoiceCapable)
            ->setGeocastCapable($geocastCapable)
            ->setStreamingCapable($streamingCapable)
            ->setMaxStreamingSpd($maxStreamingSpd)
            ->setMaxDataSpeed($maxDataSpeed)
            ->setServiceCat($serviceCat)
            ->setServiceClass($serviceClass)
            ->setClassmark($classmark)
            ->setStatus($status)
            ->setCertT($certT)
            ->setCertBy($certBy)
            ->setSafetyCapable($safetyCapable)
            ->setSeClassMark($seClassMark)
            ->setMaxB1Spd($maxB1Spd)
            ->setMaxNextSpd($maxNextSpd)
            ->setC8ModCod($c8ModCod);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ModelImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get vertical value
     * @return string|null
     */
    public function getVertical()
    {
        return $this->vertical;
    }
    /**
     * Set vertical value
     * @param string $vertical
     * @return \StructType\ModelImpl
     */
    public function setVertical($vertical = null)
    {
        // validation for constraint: string
        if (!is_null($vertical) && !is_string($vertical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vertical)), __LINE__);
        }
        $this->vertical = $vertical;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \StructType\ModelImpl
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ModelImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get modelNumber value
     * @return string|null
     */
    public function getModelNumber()
    {
        return $this->modelNumber;
    }
    /**
     * Set modelNumber value
     * @param string $modelNumber
     * @return \StructType\ModelImpl
     */
    public function setModelNumber($modelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modelNumber) && !is_string($modelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelNumber)), __LINE__);
        }
        $this->modelNumber = $modelNumber;
        return $this;
    }
    /**
     * Get sbdCapable value
     * @return string|null
     */
    public function getSbdCapable()
    {
        return $this->sbdCapable;
    }
    /**
     * Set sbdCapable value
     * @param string $sbdCapable
     * @return \StructType\ModelImpl
     */
    public function setSbdCapable($sbdCapable = null)
    {
        // validation for constraint: string
        if (!is_null($sbdCapable) && !is_string($sbdCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sbdCapable)), __LINE__);
        }
        $this->sbdCapable = $sbdCapable;
        return $this;
    }
    /**
     * Get pttCapable value
     * @return string|null
     */
    public function getPttCapable()
    {
        return $this->pttCapable;
    }
    /**
     * Set pttCapable value
     * @param string $pttCapable
     * @return \StructType\ModelImpl
     */
    public function setPttCapable($pttCapable = null)
    {
        // validation for constraint: string
        if (!is_null($pttCapable) && !is_string($pttCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pttCapable)), __LINE__);
        }
        $this->pttCapable = $pttCapable;
        return $this;
    }
    /**
     * Get burstCapable value
     * @return string|null
     */
    public function getBurstCapable()
    {
        return $this->burstCapable;
    }
    /**
     * Set burstCapable value
     * @param string $burstCapable
     * @return \StructType\ModelImpl
     */
    public function setBurstCapable($burstCapable = null)
    {
        // validation for constraint: string
        if (!is_null($burstCapable) && !is_string($burstCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($burstCapable)), __LINE__);
        }
        $this->burstCapable = $burstCapable;
        return $this;
    }
    /**
     * Get opCapable value
     * @return string|null
     */
    public function getOpCapable()
    {
        return $this->opCapable;
    }
    /**
     * Set opCapable value
     * @param string $opCapable
     * @return \StructType\ModelImpl
     */
    public function setOpCapable($opCapable = null)
    {
        // validation for constraint: string
        if (!is_null($opCapable) && !is_string($opCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opCapable)), __LINE__);
        }
        $this->opCapable = $opCapable;
        return $this;
    }
    /**
     * Get telCapable value
     * @return string|null
     */
    public function getTelCapable()
    {
        return $this->telCapable;
    }
    /**
     * Set telCapable value
     * @param string $telCapable
     * @return \StructType\ModelImpl
     */
    public function setTelCapable($telCapable = null)
    {
        // validation for constraint: string
        if (!is_null($telCapable) && !is_string($telCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telCapable)), __LINE__);
        }
        $this->telCapable = $telCapable;
        return $this;
    }
    /**
     * Get certusVoiceCapable value
     * @return string|null
     */
    public function getCertusVoiceCapable()
    {
        return $this->certusVoiceCapable;
    }
    /**
     * Set certusVoiceCapable value
     * @param string $certusVoiceCapable
     * @return \StructType\ModelImpl
     */
    public function setCertusVoiceCapable($certusVoiceCapable = null)
    {
        // validation for constraint: string
        if (!is_null($certusVoiceCapable) && !is_string($certusVoiceCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certusVoiceCapable)), __LINE__);
        }
        $this->certusVoiceCapable = $certusVoiceCapable;
        return $this;
    }
    /**
     * Get geocastCapable value
     * @return string|null
     */
    public function getGeocastCapable()
    {
        return $this->geocastCapable;
    }
    /**
     * Set geocastCapable value
     * @param string $geocastCapable
     * @return \StructType\ModelImpl
     */
    public function setGeocastCapable($geocastCapable = null)
    {
        // validation for constraint: string
        if (!is_null($geocastCapable) && !is_string($geocastCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geocastCapable)), __LINE__);
        }
        $this->geocastCapable = $geocastCapable;
        return $this;
    }
    /**
     * Get streamingCapable value
     * @return string|null
     */
    public function getStreamingCapable()
    {
        return $this->streamingCapable;
    }
    /**
     * Set streamingCapable value
     * @param string $streamingCapable
     * @return \StructType\ModelImpl
     */
    public function setStreamingCapable($streamingCapable = null)
    {
        // validation for constraint: string
        if (!is_null($streamingCapable) && !is_string($streamingCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streamingCapable)), __LINE__);
        }
        $this->streamingCapable = $streamingCapable;
        return $this;
    }
    /**
     * Get maxStreamingSpd value
     * @return string|null
     */
    public function getMaxStreamingSpd()
    {
        return $this->maxStreamingSpd;
    }
    /**
     * Set maxStreamingSpd value
     * @uses \EnumType\StreamingSpeedEnum::valueIsValid()
     * @uses \EnumType\StreamingSpeedEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxStreamingSpd
     * @return \StructType\ModelImpl
     */
    public function setMaxStreamingSpd($maxStreamingSpd = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StreamingSpeedEnum::valueIsValid($maxStreamingSpd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxStreamingSpd, implode(', ', \EnumType\StreamingSpeedEnum::getValidValues())), __LINE__);
        }
        $this->maxStreamingSpd = $maxStreamingSpd;
        return $this;
    }
    /**
     * Get maxDataSpeed value
     * @return int|null
     */
    public function getMaxDataSpeed()
    {
        return $this->maxDataSpeed;
    }
    /**
     * Set maxDataSpeed value
     * @param int $maxDataSpeed
     * @return \StructType\ModelImpl
     */
    public function setMaxDataSpeed($maxDataSpeed = null)
    {
        // validation for constraint: int
        if (!is_null($maxDataSpeed) && !is_numeric($maxDataSpeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxDataSpeed)), __LINE__);
        }
        $this->maxDataSpeed = $maxDataSpeed;
        return $this;
    }
    /**
     * Get serviceCat value
     * @return string|null
     */
    public function getServiceCat()
    {
        return $this->serviceCat;
    }
    /**
     * Set serviceCat value
     * @uses \EnumType\ModelServiceCategoryEnum::valueIsValid()
     * @uses \EnumType\ModelServiceCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCat
     * @return \StructType\ModelImpl
     */
    public function setServiceCat($serviceCat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModelServiceCategoryEnum::valueIsValid($serviceCat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceCat, implode(', ', \EnumType\ModelServiceCategoryEnum::getValidValues())), __LINE__);
        }
        $this->serviceCat = $serviceCat;
        return $this;
    }
    /**
     * Get serviceClass value
     * @return string|null
     */
    public function getServiceClass()
    {
        return $this->serviceClass;
    }
    /**
     * Set serviceClass value
     * @uses \EnumType\ModelServiceClassEnum::valueIsValid()
     * @uses \EnumType\ModelServiceClassEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceClass
     * @return \StructType\ModelImpl
     */
    public function setServiceClass($serviceClass = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModelServiceClassEnum::valueIsValid($serviceClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceClass, implode(', ', \EnumType\ModelServiceClassEnum::getValidValues())), __LINE__);
        }
        $this->serviceClass = $serviceClass;
        return $this;
    }
    /**
     * Get classmark value
     * @return string|null
     */
    public function getClassmark()
    {
        return $this->classmark;
    }
    /**
     * Set classmark value
     * @uses \EnumType\DataClassmarkEnum::valueIsValid()
     * @uses \EnumType\DataClassmarkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classmark
     * @return \StructType\ModelImpl
     */
    public function setClassmark($classmark = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DataClassmarkEnum::valueIsValid($classmark)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $classmark, implode(', ', \EnumType\DataClassmarkEnum::getValidValues())), __LINE__);
        }
        $this->classmark = $classmark;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ObjectStatusEnum::valueIsValid()
     * @uses \EnumType\ObjectStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ModelImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObjectStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ObjectStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get certT value
     * @return string|null
     */
    public function getCertT()
    {
        return $this->certT;
    }
    /**
     * Set certT value
     * @param string $certT
     * @return \StructType\ModelImpl
     */
    public function setCertT($certT = null)
    {
        // validation for constraint: string
        if (!is_null($certT) && !is_string($certT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certT)), __LINE__);
        }
        $this->certT = $certT;
        return $this;
    }
    /**
     * Get certBy value
     * @return string|null
     */
    public function getCertBy()
    {
        return $this->certBy;
    }
    /**
     * Set certBy value
     * @param string $certBy
     * @return \StructType\ModelImpl
     */
    public function setCertBy($certBy = null)
    {
        // validation for constraint: string
        if (!is_null($certBy) && !is_string($certBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certBy)), __LINE__);
        }
        $this->certBy = $certBy;
        return $this;
    }
    /**
     * Get safetyCapable value
     * @return string|null
     */
    public function getSafetyCapable()
    {
        return $this->safetyCapable;
    }
    /**
     * Set safetyCapable value
     * @param string $safetyCapable
     * @return \StructType\ModelImpl
     */
    public function setSafetyCapable($safetyCapable = null)
    {
        // validation for constraint: string
        if (!is_null($safetyCapable) && !is_string($safetyCapable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($safetyCapable)), __LINE__);
        }
        $this->safetyCapable = $safetyCapable;
        return $this;
    }
    /**
     * Get seClassMark value
     * @return string|null
     */
    public function getSeClassMark()
    {
        return $this->seClassMark;
    }
    /**
     * Set seClassMark value
     * @param string $seClassMark
     * @return \StructType\ModelImpl
     */
    public function setSeClassMark($seClassMark = null)
    {
        // validation for constraint: string
        if (!is_null($seClassMark) && !is_string($seClassMark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seClassMark)), __LINE__);
        }
        $this->seClassMark = $seClassMark;
        return $this;
    }
    /**
     * Get maxB1Spd value
     * @return int|null
     */
    public function getMaxB1Spd()
    {
        return $this->maxB1Spd;
    }
    /**
     * Set maxB1Spd value
     * @param int $maxB1Spd
     * @return \StructType\ModelImpl
     */
    public function setMaxB1Spd($maxB1Spd = null)
    {
        // validation for constraint: int
        if (!is_null($maxB1Spd) && !is_numeric($maxB1Spd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxB1Spd)), __LINE__);
        }
        $this->maxB1Spd = $maxB1Spd;
        return $this;
    }
    /**
     * Get maxNextSpd value
     * @return int|null
     */
    public function getMaxNextSpd()
    {
        return $this->maxNextSpd;
    }
    /**
     * Set maxNextSpd value
     * @param int $maxNextSpd
     * @return \StructType\ModelImpl
     */
    public function setMaxNextSpd($maxNextSpd = null)
    {
        // validation for constraint: int
        if (!is_null($maxNextSpd) && !is_numeric($maxNextSpd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNextSpd)), __LINE__);
        }
        $this->maxNextSpd = $maxNextSpd;
        return $this;
    }
    /**
     * Get c8ModCod value
     * @return string|null
     */
    public function getC8ModCod()
    {
        return $this->c8ModCod;
    }
    /**
     * Set c8ModCod value
     * @param string $c8ModCod
     * @return \StructType\ModelImpl
     */
    public function setC8ModCod($c8ModCod = null)
    {
        // validation for constraint: string
        if (!is_null($c8ModCod) && !is_string($c8ModCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c8ModCod)), __LINE__);
        }
        $this->c8ModCod = $c8ModCod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModelImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
