<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageIds StructType
 * @subpackage Structs
 */
class MessageIds extends AbstractStructBase
{
    /**
     * The messageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $messageId;
    /**
     * Constructor method for messageIds
     * @uses MessageIds::setMessageId()
     * @param string[] $messageId
     */
    public function __construct(array $messageId = array())
    {
        $this
            ->setMessageId($messageId);
    }
    /**
     * Get messageId value
     * @return string[]|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @throws \InvalidArgumentException
     * @param string[] $messageId
     * @return \StructType\MessageIds
     */
    public function setMessageId(array $messageId = array())
    {
        foreach ($messageId as $messageIdsMessageIdItem) {
            // validation for constraint: itemType
            if (!is_string($messageIdsMessageIdItem)) {
                throw new \InvalidArgumentException(sprintf('The messageId property can only contain items of string, "%s" given', is_object($messageIdsMessageIdItem) ? get_class($messageIdsMessageIdItem) : gettype($messageIdsMessageIdItem)), __LINE__);
            }
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Add item to messageId value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\MessageIds
     */
    public function addToMessageId($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The messageId property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->messageId[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageIds
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
