<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for m2MSubscriberAccountImpl StructType
 * @subpackage Structs
 */
class M2MSubscriberAccountImpl extends AbsSubscriberAccountImpl
{
    /**
     * The plan
     * @var \StructType\M2MPlanImpl
     */
    public $plan;
    /**
     * The subscriberAccountMetadata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\M2MSubscriberAccountMetadataImpl
     */
    public $subscriberAccountMetadata;
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The msisdnc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeviceImpl
     */
    public $msisdnc;
    /**
     * The msisdnb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeviceImpl
     */
    public $msisdnb;
    /**
     * The bulkAction
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $bulkAction;
    /**
     * The m2mBulkDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\M2mBulkDetails
     */
    public $m2mBulkDetails;
    /**
     * The deliveryDetails
     * @var \StructType\DeliveryDetails
     */
    public $deliveryDetails;
    /**
     * The mtFilters
     * @var \StructType\MtFilters
     */
    public $mtFilters;
    /**
     * Constructor method for m2MSubscriberAccountImpl
     * @uses M2MSubscriberAccountImpl::setPlan()
     * @uses M2MSubscriberAccountImpl::setSubscriberAccountMetadata()
     * @uses M2MSubscriberAccountImpl::setImei()
     * @uses M2MSubscriberAccountImpl::setMsisdnc()
     * @uses M2MSubscriberAccountImpl::setMsisdnb()
     * @uses M2MSubscriberAccountImpl::setBulkAction()
     * @uses M2MSubscriberAccountImpl::setM2mBulkDetails()
     * @uses M2MSubscriberAccountImpl::setDeliveryDetails()
     * @uses M2MSubscriberAccountImpl::setMtFilters()
     * @param \StructType\M2MPlanImpl $plan
     * @param \StructType\M2MSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @param string $imei
     * @param \StructType\DeviceImpl $msisdnc
     * @param \StructType\DeviceImpl $msisdnb
     * @param bool $bulkAction
     * @param \StructType\M2mBulkDetails $m2mBulkDetails
     * @param \StructType\DeliveryDetails $deliveryDetails
     * @param \StructType\MtFilters $mtFilters
     */
    public function __construct(\StructType\M2MPlanImpl $plan = null, \StructType\M2MSubscriberAccountMetadataImpl $subscriberAccountMetadata = null, $imei = null, \StructType\DeviceImpl $msisdnc = null, \StructType\DeviceImpl $msisdnb = null, $bulkAction = false, \StructType\M2mBulkDetails $m2mBulkDetails = null, \StructType\DeliveryDetails $deliveryDetails = null, \StructType\MtFilters $mtFilters = null)
    {
        $this
            ->setPlan($plan)
            ->setSubscriberAccountMetadata($subscriberAccountMetadata)
            ->setImei($imei)
            ->setMsisdnc($msisdnc)
            ->setMsisdnb($msisdnb)
            ->setBulkAction($bulkAction)
            ->setM2mBulkDetails($m2mBulkDetails)
            ->setDeliveryDetails($deliveryDetails)
            ->setMtFilters($mtFilters);
    }
    /**
     * Get plan value
     * @return \StructType\M2MPlanImpl|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param \StructType\M2MPlanImpl $plan
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setPlan(\StructType\M2MPlanImpl $plan = null)
    {
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get subscriberAccountMetadata value
     * @return \StructType\M2MSubscriberAccountMetadataImpl|null
     */
    public function getSubscriberAccountMetadata()
    {
        return $this->subscriberAccountMetadata;
    }
    /**
     * Set subscriberAccountMetadata value
     * @param \StructType\M2MSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setSubscriberAccountMetadata(\StructType\M2MSubscriberAccountMetadataImpl $subscriberAccountMetadata = null)
    {
        $this->subscriberAccountMetadata = $subscriberAccountMetadata;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get msisdnc value
     * @return \StructType\DeviceImpl|null
     */
    public function getMsisdnc()
    {
        return $this->msisdnc;
    }
    /**
     * Set msisdnc value
     * @param \StructType\DeviceImpl $msisdnc
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setMsisdnc(\StructType\DeviceImpl $msisdnc = null)
    {
        $this->msisdnc = $msisdnc;
        return $this;
    }
    /**
     * Get msisdnb value
     * @return \StructType\DeviceImpl|null
     */
    public function getMsisdnb()
    {
        return $this->msisdnb;
    }
    /**
     * Set msisdnb value
     * @param \StructType\DeviceImpl $msisdnb
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setMsisdnb(\StructType\DeviceImpl $msisdnb = null)
    {
        $this->msisdnb = $msisdnb;
        return $this;
    }
    /**
     * Get bulkAction value
     * @return bool|null
     */
    public function getBulkAction()
    {
        return $this->bulkAction;
    }
    /**
     * Set bulkAction value
     * @param bool $bulkAction
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setBulkAction($bulkAction = false)
    {
        $this->bulkAction = $bulkAction;
        return $this;
    }
    /**
     * Get m2mBulkDetails value
     * @return \StructType\M2mBulkDetails|null
     */
    public function getM2mBulkDetails()
    {
        return $this->m2mBulkDetails;
    }
    /**
     * Set m2mBulkDetails value
     * @param \StructType\M2mBulkDetails $m2mBulkDetails
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setM2mBulkDetails(\StructType\M2mBulkDetails $m2mBulkDetails = null)
    {
        $this->m2mBulkDetails = $m2mBulkDetails;
        return $this;
    }
    /**
     * Get deliveryDetails value
     * @return \StructType\DeliveryDetails|null
     */
    public function getDeliveryDetails()
    {
        return $this->deliveryDetails;
    }
    /**
     * Set deliveryDetails value
     * @param \StructType\DeliveryDetails $deliveryDetails
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setDeliveryDetails(\StructType\DeliveryDetails $deliveryDetails = null)
    {
        $this->deliveryDetails = $deliveryDetails;
        return $this;
    }
    /**
     * Get mtFilters value
     * @return \StructType\MtFilters|null
     */
    public function getMtFilters()
    {
        return $this->mtFilters;
    }
    /**
     * Set mtFilters value
     * @param \StructType\MtFilters $mtFilters
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public function setMtFilters(\StructType\MtFilters $mtFilters = null)
    {
        $this->mtFilters = $mtFilters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\M2MSubscriberAccountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
