<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for m2MPlanImpl StructType
 * @subpackage Structs
 */
class M2MPlanImpl extends AbsPlanImpl
{
    /**
     * The m2mBundleId
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var string
     */
    public $m2mBundleId;
    /**
     * The rudicsGroup
     * @var string
     */
    public $rudicsGroup;
    /**
     * The lritFlagstate
     * @var string
     */
    public $lritFlagstate;
    /**
     * The ringAlertsFlag
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $ringAlertsFlag;
    /**
     * Constructor method for m2MPlanImpl
     * @uses M2MPlanImpl::setM2mBundleId()
     * @uses M2MPlanImpl::setRudicsGroup()
     * @uses M2MPlanImpl::setLritFlagstate()
     * @uses M2MPlanImpl::setRingAlertsFlag()
     * @param string $m2mBundleId
     * @param string $rudicsGroup
     * @param string $lritFlagstate
     * @param bool $ringAlertsFlag
     */
    public function __construct($m2mBundleId = '0', $rudicsGroup = null, $lritFlagstate = null, $ringAlertsFlag = false)
    {
        $this
            ->setM2mBundleId($m2mBundleId)
            ->setRudicsGroup($rudicsGroup)
            ->setLritFlagstate($lritFlagstate)
            ->setRingAlertsFlag($ringAlertsFlag);
    }
    /**
     * Get m2mBundleId value
     * @return string|null
     */
    public function getM2mBundleId()
    {
        return $this->m2mBundleId;
    }
    /**
     * Set m2mBundleId value
     * @param string $m2mBundleId
     * @return \StructType\M2MPlanImpl
     */
    public function setM2mBundleId($m2mBundleId = '0')
    {
        // validation for constraint: string
        if (!is_null($m2mBundleId) && !is_string($m2mBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($m2mBundleId)), __LINE__);
        }
        $this->m2mBundleId = $m2mBundleId;
        return $this;
    }
    /**
     * Get rudicsGroup value
     * @return string|null
     */
    public function getRudicsGroup()
    {
        return $this->rudicsGroup;
    }
    /**
     * Set rudicsGroup value
     * @param string $rudicsGroup
     * @return \StructType\M2MPlanImpl
     */
    public function setRudicsGroup($rudicsGroup = null)
    {
        // validation for constraint: string
        if (!is_null($rudicsGroup) && !is_string($rudicsGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rudicsGroup)), __LINE__);
        }
        $this->rudicsGroup = $rudicsGroup;
        return $this;
    }
    /**
     * Get lritFlagstate value
     * @return string|null
     */
    public function getLritFlagstate()
    {
        return $this->lritFlagstate;
    }
    /**
     * Set lritFlagstate value
     * @param string $lritFlagstate
     * @return \StructType\M2MPlanImpl
     */
    public function setLritFlagstate($lritFlagstate = null)
    {
        // validation for constraint: string
        if (!is_null($lritFlagstate) && !is_string($lritFlagstate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lritFlagstate)), __LINE__);
        }
        $this->lritFlagstate = $lritFlagstate;
        return $this;
    }
    /**
     * Get ringAlertsFlag value
     * @return bool|null
     */
    public function getRingAlertsFlag()
    {
        return $this->ringAlertsFlag;
    }
    /**
     * Set ringAlertsFlag value
     * @param bool $ringAlertsFlag
     * @return \StructType\M2MPlanImpl
     */
    public function setRingAlertsFlag($ringAlertsFlag = false)
    {
        $this->ringAlertsFlag = $ringAlertsFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\M2MPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
