<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for imeiProfileImpl StructType
 * @subpackage Structs
 */
class ImeiProfileImpl extends AbstractStructBase
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The tac
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tac;
    /**
     * The fac
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fac;
    /**
     * The maxMessageSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxMessageSize;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The flags
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flags;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The submarket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarket;
    /**
     * The vertical
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VerticalImpl
     */
    public $vertical;
    /**
     * Constructor method for imeiProfileImpl
     * @uses ImeiProfileImpl::setServiceType()
     * @uses ImeiProfileImpl::setTac()
     * @uses ImeiProfileImpl::setFac()
     * @uses ImeiProfileImpl::setMaxMessageSize()
     * @uses ImeiProfileImpl::setDescription()
     * @uses ImeiProfileImpl::setFlags()
     * @uses ImeiProfileImpl::setModel()
     * @uses ImeiProfileImpl::setSubmarket()
     * @uses ImeiProfileImpl::setVertical()
     * @param string $serviceType
     * @param string $tac
     * @param string $fac
     * @param int $maxMessageSize
     * @param string $description
     * @param string $flags
     * @param string $model
     * @param string $submarket
     * @param \StructType\VerticalImpl $vertical
     */
    public function __construct($serviceType = null, $tac = null, $fac = null, $maxMessageSize = null, $description = null, $flags = null, $model = null, $submarket = null, \StructType\VerticalImpl $vertical = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setTac($tac)
            ->setFac($fac)
            ->setMaxMessageSize($maxMessageSize)
            ->setDescription($description)
            ->setFlags($flags)
            ->setModel($model)
            ->setSubmarket($submarket)
            ->setVertical($vertical);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\ImeiProfileImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get tac value
     * @return string|null
     */
    public function getTac()
    {
        return $this->tac;
    }
    /**
     * Set tac value
     * @param string $tac
     * @return \StructType\ImeiProfileImpl
     */
    public function setTac($tac = null)
    {
        // validation for constraint: string
        if (!is_null($tac) && !is_string($tac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tac)), __LINE__);
        }
        $this->tac = $tac;
        return $this;
    }
    /**
     * Get fac value
     * @return string|null
     */
    public function getFac()
    {
        return $this->fac;
    }
    /**
     * Set fac value
     * @param string $fac
     * @return \StructType\ImeiProfileImpl
     */
    public function setFac($fac = null)
    {
        // validation for constraint: string
        if (!is_null($fac) && !is_string($fac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fac)), __LINE__);
        }
        $this->fac = $fac;
        return $this;
    }
    /**
     * Get maxMessageSize value
     * @return int|null
     */
    public function getMaxMessageSize()
    {
        return $this->maxMessageSize;
    }
    /**
     * Set maxMessageSize value
     * @param int $maxMessageSize
     * @return \StructType\ImeiProfileImpl
     */
    public function setMaxMessageSize($maxMessageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxMessageSize) && !is_numeric($maxMessageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxMessageSize)), __LINE__);
        }
        $this->maxMessageSize = $maxMessageSize;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ImeiProfileImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get flags value
     * @return string|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @uses \EnumType\ImeiTypeEnum::valueIsValid()
     * @uses \EnumType\ImeiTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flags
     * @return \StructType\ImeiProfileImpl
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImeiTypeEnum::valueIsValid($flags)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $flags, implode(', ', \EnumType\ImeiTypeEnum::getValidValues())), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \StructType\ImeiProfileImpl
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get submarket value
     * @return string|null
     */
    public function getSubmarket()
    {
        return $this->submarket;
    }
    /**
     * Set submarket value
     * @param string $submarket
     * @return \StructType\ImeiProfileImpl
     */
    public function setSubmarket($submarket = null)
    {
        // validation for constraint: string
        if (!is_null($submarket) && !is_string($submarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarket)), __LINE__);
        }
        $this->submarket = $submarket;
        return $this;
    }
    /**
     * Get vertical value
     * @return \StructType\VerticalImpl|null
     */
    public function getVertical()
    {
        return $this->vertical;
    }
    /**
     * Set vertical value
     * @param \StructType\VerticalImpl $vertical
     * @return \StructType\ImeiProfileImpl
     */
    public function setVertical(\StructType\VerticalImpl $vertical = null)
    {
        $this->vertical = $vertical;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImeiProfileImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
