<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTransactionHistoryReportResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getTransactionHistoryReportResponseImpl
 * @subpackage Structs
 */
class GetTransactionHistoryReportResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The transactions
     * @var \StructType\Transactions
     */
    public $transactions;
    /**
     * Constructor method for getTransactionHistoryReportResponseImpl
     * @uses GetTransactionHistoryReportResponseImpl::setTotalNumberOfRecords()
     * @uses GetTransactionHistoryReportResponseImpl::setTransactions()
     * @param int $totalNumberOfRecords
     * @param \StructType\Transactions $transactions
     */
    public function __construct($totalNumberOfRecords = null, \StructType\Transactions $transactions = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setTransactions($transactions);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetTransactionHistoryReportResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get transactions value
     * @return \StructType\Transactions|null
     */
    public function getTransactions()
    {
        return $this->transactions;
    }
    /**
     * Set transactions value
     * @param \StructType\Transactions $transactions
     * @return \StructType\GetTransactionHistoryReportResponseImpl
     */
    public function setTransactions(\StructType\Transactions $transactions = null)
    {
        $this->transactions = $transactions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTransactionHistoryReportResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
