<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getServicePlansRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getServicePlansRequestImpl
 * @subpackage Structs
 */
class GetServicePlansRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The submarket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarket;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The isDemoTrial
     * @var string
     */
    public $isDemoTrial;
    /**
     * The forActivate
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $forActivate;
    /**
     * The fromPlanId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromPlanId;
    /**
     * The isPrepaidActive
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $isPrepaidActive;
    /**
     * Constructor method for getServicePlansRequestImpl
     * @uses GetServicePlansRequestImpl::setServiceType()
     * @uses GetServicePlansRequestImpl::setSubmarket()
     * @uses GetServicePlansRequestImpl::setModel()
     * @uses GetServicePlansRequestImpl::setIsDemoTrial()
     * @uses GetServicePlansRequestImpl::setForActivate()
     * @uses GetServicePlansRequestImpl::setFromPlanId()
     * @uses GetServicePlansRequestImpl::setIsPrepaidActive()
     * @param string $serviceType
     * @param string $submarket
     * @param string $model
     * @param string $isDemoTrial
     * @param bool $forActivate
     * @param string $fromPlanId
     * @param bool $isPrepaidActive
     */
    public function __construct($serviceType = null, $submarket = null, $model = null, $isDemoTrial = null, $forActivate = true, $fromPlanId = null, $isPrepaidActive = false)
    {
        $this
            ->setServiceType($serviceType)
            ->setSubmarket($submarket)
            ->setModel($model)
            ->setIsDemoTrial($isDemoTrial)
            ->setForActivate($forActivate)
            ->setFromPlanId($fromPlanId)
            ->setIsPrepaidActive($isPrepaidActive);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get submarket value
     * @return string|null
     */
    public function getSubmarket()
    {
        return $this->submarket;
    }
    /**
     * Set submarket value
     * @param string $submarket
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setSubmarket($submarket = null)
    {
        // validation for constraint: string
        if (!is_null($submarket) && !is_string($submarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarket)), __LINE__);
        }
        $this->submarket = $submarket;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setModel($model = null)
    {
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get isDemoTrial value
     * @return string|null
     */
    public function getIsDemoTrial()
    {
        return $this->isDemoTrial;
    }
    /**
     * Set isDemoTrial value
     * @uses \EnumType\DatTypeEnum::valueIsValid()
     * @uses \EnumType\DatTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isDemoTrial
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setIsDemoTrial($isDemoTrial = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatTypeEnum::valueIsValid($isDemoTrial)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $isDemoTrial, implode(', ', \EnumType\DatTypeEnum::getValidValues())), __LINE__);
        }
        $this->isDemoTrial = $isDemoTrial;
        return $this;
    }
    /**
     * Get forActivate value
     * @return bool|null
     */
    public function getForActivate()
    {
        return $this->forActivate;
    }
    /**
     * Set forActivate value
     * @param bool $forActivate
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setForActivate($forActivate = true)
    {
        $this->forActivate = $forActivate;
        return $this;
    }
    /**
     * Get fromPlanId value
     * @return string|null
     */
    public function getFromPlanId()
    {
        return $this->fromPlanId;
    }
    /**
     * Set fromPlanId value
     * @param string $fromPlanId
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setFromPlanId($fromPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($fromPlanId) && !is_string($fromPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromPlanId)), __LINE__);
        }
        $this->fromPlanId = $fromPlanId;
        return $this;
    }
    /**
     * Get isPrepaidActive value
     * @return bool|null
     */
    public function getIsPrepaidActive()
    {
        return $this->isPrepaidActive;
    }
    /**
     * Set isPrepaidActive value
     * @param bool $isPrepaidActive
     * @return \StructType\GetServicePlansRequestImpl
     */
    public function setIsPrepaidActive($isPrepaidActive = false)
    {
        $this->isPrepaidActive = $isPrepaidActive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServicePlansRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
