<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getScratchCardsResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getScratchCardsResponseImpl
 * @subpackage Structs
 */
class GetScratchCardsResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The scratchCards
     * @var \StructType\ScratchCards
     */
    public $scratchCards;
    /**
     * Constructor method for getScratchCardsResponseImpl
     * @uses GetScratchCardsResponseImpl::setTotalNumberOfRecords()
     * @uses GetScratchCardsResponseImpl::setScratchCards()
     * @param int $totalNumberOfRecords
     * @param \StructType\ScratchCards $scratchCards
     */
    public function __construct($totalNumberOfRecords = null, \StructType\ScratchCards $scratchCards = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setScratchCards($scratchCards);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetScratchCardsResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get scratchCards value
     * @return \StructType\ScratchCards|null
     */
    public function getScratchCards()
    {
        return $this->scratchCards;
    }
    /**
     * Set scratchCards value
     * @param \StructType\ScratchCards $scratchCards
     * @return \StructType\GetScratchCardsResponseImpl
     */
    public function setScratchCards(\StructType\ScratchCards $scratchCards = null)
    {
        $this->scratchCards = $scratchCards;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetScratchCardsResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
