<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCallSummaryReportResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getCallSummaryReportResponseImpl
 * @subpackage Structs
 */
class GetCallSummaryReportResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The calls
     * @var \StructType\Calls
     */
    public $calls;
    /**
     * Constructor method for getCallSummaryReportResponseImpl
     * @uses GetCallSummaryReportResponseImpl::setTotalNumberOfRecords()
     * @uses GetCallSummaryReportResponseImpl::setCalls()
     * @param int $totalNumberOfRecords
     * @param \StructType\Calls $calls
     */
    public function __construct($totalNumberOfRecords = null, \StructType\Calls $calls = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setCalls($calls);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetCallSummaryReportResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get calls value
     * @return \StructType\Calls|null
     */
    public function getCalls()
    {
        return $this->calls;
    }
    /**
     * Set calls value
     * @param \StructType\Calls $calls
     * @return \StructType\GetCallSummaryReportResponseImpl
     */
    public function setCalls(\StructType\Calls $calls = null)
    {
        $this->calls = $calls;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCallSummaryReportResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
