<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCallSummaryReportRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getCallSummaryReportRequestImpl
 * @subpackage Structs
 */
class GetCallSummaryReportRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The billcycleMonthYear
     * @var string
     */
    public $billcycleMonthYear;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for getCallSummaryReportRequestImpl
     * @uses GetCallSummaryReportRequestImpl::setServiceType()
     * @uses GetCallSummaryReportRequestImpl::setAccountNumber()
     * @uses GetCallSummaryReportRequestImpl::setBillcycleMonthYear()
     * @uses GetCallSummaryReportRequestImpl::setLimit()
     * @uses GetCallSummaryReportRequestImpl::setStartRow()
     * @param string $serviceType
     * @param string $accountNumber
     * @param string $billcycleMonthYear
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($serviceType = null, $accountNumber = null, $billcycleMonthYear = null, $limit = null, $startRow = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setAccountNumber($accountNumber)
            ->setBillcycleMonthYear($billcycleMonthYear)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get billcycleMonthYear value
     * @return string|null
     */
    public function getBillcycleMonthYear()
    {
        return $this->billcycleMonthYear;
    }
    /**
     * Set billcycleMonthYear value
     * @param string $billcycleMonthYear
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public function setBillcycleMonthYear($billcycleMonthYear = null)
    {
        // validation for constraint: string
        if (!is_null($billcycleMonthYear) && !is_string($billcycleMonthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billcycleMonthYear)), __LINE__);
        }
        $this->billcycleMonthYear = $billcycleMonthYear;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCallSummaryReportRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
