<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deviceTransferOwnerRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:deviceTransferOwnerRequestImpl
 * @subpackage Structs
 */
class DeviceTransferOwnerRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The deviceStringType
     * @var string
     */
    public $deviceStringType;
    /**
     * The deviceString
     * @var string
     */
    public $deviceString;
    /**
     * The toSPAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toSPAccountNumber;
    /**
     * The bulkAction
     * @var bool
     */
    public $bulkAction;
    /**
     * The BulkDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BulkDetails
     */
    public $BulkDetails;
    /**
     * Constructor method for deviceTransferOwnerRequestImpl
     * @uses DeviceTransferOwnerRequestImpl::setServiceType()
     * @uses DeviceTransferOwnerRequestImpl::setDeviceStringType()
     * @uses DeviceTransferOwnerRequestImpl::setDeviceString()
     * @uses DeviceTransferOwnerRequestImpl::setToSPAccountNumber()
     * @uses DeviceTransferOwnerRequestImpl::setBulkAction()
     * @uses DeviceTransferOwnerRequestImpl::setBulkDetails()
     * @param string $serviceType
     * @param string $deviceStringType
     * @param string $deviceString
     * @param string $toSPAccountNumber
     * @param bool $bulkAction
     * @param \StructType\BulkDetails $bulkDetails
     */
    public function __construct($serviceType = null, $deviceStringType = null, $deviceString = null, $toSPAccountNumber = null, $bulkAction = null, \StructType\BulkDetails $bulkDetails = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setDeviceStringType($deviceStringType)
            ->setDeviceString($deviceString)
            ->setToSPAccountNumber($toSPAccountNumber)
            ->setBulkAction($bulkAction)
            ->setBulkDetails($bulkDetails);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get deviceStringType value
     * @return string|null
     */
    public function getDeviceStringType()
    {
        return $this->deviceStringType;
    }
    /**
     * Set deviceStringType value
     * @uses \EnumType\DeviceStringTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceStringTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceStringType
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setDeviceStringType($deviceStringType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceStringTypeEnum::valueIsValid($deviceStringType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceStringType, implode(', ', \EnumType\DeviceStringTypeEnum::getValidValues())), __LINE__);
        }
        $this->deviceStringType = $deviceStringType;
        return $this;
    }
    /**
     * Get deviceString value
     * @return string|null
     */
    public function getDeviceString()
    {
        return $this->deviceString;
    }
    /**
     * Set deviceString value
     * @param string $deviceString
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setDeviceString($deviceString = null)
    {
        // validation for constraint: string
        if (!is_null($deviceString) && !is_string($deviceString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceString)), __LINE__);
        }
        $this->deviceString = $deviceString;
        return $this;
    }
    /**
     * Get toSPAccountNumber value
     * @return string|null
     */
    public function getToSPAccountNumber()
    {
        return $this->toSPAccountNumber;
    }
    /**
     * Set toSPAccountNumber value
     * @param string $toSPAccountNumber
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setToSPAccountNumber($toSPAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($toSPAccountNumber) && !is_string($toSPAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toSPAccountNumber)), __LINE__);
        }
        $this->toSPAccountNumber = $toSPAccountNumber;
        return $this;
    }
    /**
     * Get bulkAction value
     * @return bool|null
     */
    public function getBulkAction()
    {
        return $this->bulkAction;
    }
    /**
     * Set bulkAction value
     * @param bool $bulkAction
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setBulkAction($bulkAction = null)
    {
        $this->bulkAction = $bulkAction;
        return $this;
    }
    /**
     * Get BulkDetails value
     * @return \StructType\BulkDetails|null
     */
    public function getBulkDetails()
    {
        return $this->BulkDetails;
    }
    /**
     * Set BulkDetails value
     * @param \StructType\BulkDetails $bulkDetails
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public function setBulkDetails(\StructType\BulkDetails $bulkDetails = null)
    {
        $this->BulkDetails = $bulkDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeviceTransferOwnerRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
