<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deviceNumberImpl StructType
 * @subpackage Structs
 */
class DeviceNumberImpl extends DeviceImpl
{
    /**
     * The numberType
     * @var string
     */
    public $numberType;
    /**
     * The localNumberModel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localNumberModel;
    /**
     * The submarketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarketId;
    /**
     * The submarketType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarketType;
    /**
     * The network
     * @var string
     */
    public $network;
    /**
     * Constructor method for deviceNumberImpl
     * @uses DeviceNumberImpl::setNumberType()
     * @uses DeviceNumberImpl::setLocalNumberModel()
     * @uses DeviceNumberImpl::setSubmarketId()
     * @uses DeviceNumberImpl::setSubmarketType()
     * @uses DeviceNumberImpl::setNetwork()
     * @param string $numberType
     * @param string $localNumberModel
     * @param string $submarketId
     * @param string $submarketType
     * @param string $network
     */
    public function __construct($numberType = null, $localNumberModel = null, $submarketId = null, $submarketType = null, $network = null)
    {
        $this
            ->setNumberType($numberType)
            ->setLocalNumberModel($localNumberModel)
            ->setSubmarketId($submarketId)
            ->setSubmarketType($submarketType)
            ->setNetwork($network);
    }
    /**
     * Get numberType value
     * @return string|null
     */
    public function getNumberType()
    {
        return $this->numberType;
    }
    /**
     * Set numberType value
     * @uses \EnumType\DeviceNumberTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceNumberTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberType
     * @return \StructType\DeviceNumberImpl
     */
    public function setNumberType($numberType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceNumberTypeEnum::valueIsValid($numberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberType, implode(', ', \EnumType\DeviceNumberTypeEnum::getValidValues())), __LINE__);
        }
        $this->numberType = $numberType;
        return $this;
    }
    /**
     * Get localNumberModel value
     * @return string|null
     */
    public function getLocalNumberModel()
    {
        return $this->localNumberModel;
    }
    /**
     * Set localNumberModel value
     * @param string $localNumberModel
     * @return \StructType\DeviceNumberImpl
     */
    public function setLocalNumberModel($localNumberModel = null)
    {
        // validation for constraint: string
        if (!is_null($localNumberModel) && !is_string($localNumberModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localNumberModel)), __LINE__);
        }
        $this->localNumberModel = $localNumberModel;
        return $this;
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\DeviceNumberImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get submarketType value
     * @return string|null
     */
    public function getSubmarketType()
    {
        return $this->submarketType;
    }
    /**
     * Set submarketType value
     * @param string $submarketType
     * @return \StructType\DeviceNumberImpl
     */
    public function setSubmarketType($submarketType = null)
    {
        // validation for constraint: string
        if (!is_null($submarketType) && !is_string($submarketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketType)), __LINE__);
        }
        $this->submarketType = $submarketType;
        return $this;
    }
    /**
     * Get network value
     * @return string|null
     */
    public function getNetwork()
    {
        return $this->network;
    }
    /**
     * Set network value
     * @param string $network
     * @return \StructType\DeviceNumberImpl
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: string
        if (!is_null($network) && !is_string($network)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($network)), __LINE__);
        }
        $this->network = $network;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeviceNumberImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
