<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for burstSubscriberImpl StructType
 * @subpackage Structs
 */
class BurstSubscriberImpl extends AbstractStructBase
{
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The GDA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GDA;
    /**
     * The BCA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BCA;
    /**
     * The otaFlag
     * @var string
     */
    public $otaFlag;
    /**
     * The expirationDate
     * @var string
     */
    public $expirationDate;
    /**
     * The subscribedDate
     * @var string
     */
    public $subscribedDate;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for burstSubscriberImpl
     * @uses BurstSubscriberImpl::setImei()
     * @uses BurstSubscriberImpl::setGDA()
     * @uses BurstSubscriberImpl::setBCA()
     * @uses BurstSubscriberImpl::setOtaFlag()
     * @uses BurstSubscriberImpl::setExpirationDate()
     * @uses BurstSubscriberImpl::setSubscribedDate()
     * @uses BurstSubscriberImpl::setStatus()
     * @uses BurstSubscriberImpl::setServiceType()
     * @param string $imei
     * @param string $gDA
     * @param string $bCA
     * @param string $otaFlag
     * @param string $expirationDate
     * @param string $subscribedDate
     * @param string $status
     * @param string $serviceType
     */
    public function __construct($imei = null, $gDA = null, $bCA = null, $otaFlag = null, $expirationDate = null, $subscribedDate = null, $status = null, $serviceType = null)
    {
        $this
            ->setImei($imei)
            ->setGDA($gDA)
            ->setBCA($bCA)
            ->setOtaFlag($otaFlag)
            ->setExpirationDate($expirationDate)
            ->setSubscribedDate($subscribedDate)
            ->setStatus($status)
            ->setServiceType($serviceType);
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\BurstSubscriberImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get GDA value
     * @return string|null
     */
    public function getGDA()
    {
        return $this->GDA;
    }
    /**
     * Set GDA value
     * @param string $gDA
     * @return \StructType\BurstSubscriberImpl
     */
    public function setGDA($gDA = null)
    {
        // validation for constraint: string
        if (!is_null($gDA) && !is_string($gDA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gDA)), __LINE__);
        }
        $this->GDA = $gDA;
        return $this;
    }
    /**
     * Get BCA value
     * @return string|null
     */
    public function getBCA()
    {
        return $this->BCA;
    }
    /**
     * Set BCA value
     * @param string $bCA
     * @return \StructType\BurstSubscriberImpl
     */
    public function setBCA($bCA = null)
    {
        // validation for constraint: string
        if (!is_null($bCA) && !is_string($bCA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bCA)), __LINE__);
        }
        $this->BCA = $bCA;
        return $this;
    }
    /**
     * Get otaFlag value
     * @return string|null
     */
    public function getOtaFlag()
    {
        return $this->otaFlag;
    }
    /**
     * Set otaFlag value
     * @param string $otaFlag
     * @return \StructType\BurstSubscriberImpl
     */
    public function setOtaFlag($otaFlag = null)
    {
        // validation for constraint: string
        if (!is_null($otaFlag) && !is_string($otaFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($otaFlag)), __LINE__);
        }
        $this->otaFlag = $otaFlag;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\BurstSubscriberImpl
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get subscribedDate value
     * @return string|null
     */
    public function getSubscribedDate()
    {
        return $this->subscribedDate;
    }
    /**
     * Set subscribedDate value
     * @param string $subscribedDate
     * @return \StructType\BurstSubscriberImpl
     */
    public function setSubscribedDate($subscribedDate = null)
    {
        // validation for constraint: string
        if (!is_null($subscribedDate) && !is_string($subscribedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscribedDate)), __LINE__);
        }
        $this->subscribedDate = $subscribedDate;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BurstSubscriberImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\BurstSubscriberImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BurstSubscriberImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
