<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bundles StructType
 * @subpackage Structs
 */
class Bundles extends AbstractStructBase
{
    /**
     * The bulkBundle
     * @var \StructType\BulkBundleInfoImpl
     */
    public $bulkBundle;
    /**
     * The bundle
     * @var \StructType\BundleInfoImpl
     */
    public $bundle;
    /**
     * The datBundle
     * @var \StructType\DatBundleInfoImpl
     */
    public $datBundle;
    /**
     * The accountPoolBundle
     * @var \StructType\AccountPoolingBundleInfoImpl
     */
    public $accountPoolBundle;
    /**
     * Constructor method for bundles
     * @uses Bundles::setBulkBundle()
     * @uses Bundles::setBundle()
     * @uses Bundles::setDatBundle()
     * @uses Bundles::setAccountPoolBundle()
     * @param \StructType\BulkBundleInfoImpl $bulkBundle
     * @param \StructType\BundleInfoImpl $bundle
     * @param \StructType\DatBundleInfoImpl $datBundle
     * @param \StructType\AccountPoolingBundleInfoImpl $accountPoolBundle
     */
    public function __construct(\StructType\BulkBundleInfoImpl $bulkBundle = null, \StructType\BundleInfoImpl $bundle = null, \StructType\DatBundleInfoImpl $datBundle = null, \StructType\AccountPoolingBundleInfoImpl $accountPoolBundle = null)
    {
        $this
            ->setBulkBundle($bulkBundle)
            ->setBundle($bundle)
            ->setDatBundle($datBundle)
            ->setAccountPoolBundle($accountPoolBundle);
    }
    /**
     * Get bulkBundle value
     * @return \StructType\BulkBundleInfoImpl|null
     */
    public function getBulkBundle()
    {
        return $this->bulkBundle;
    }
    /**
     * Set bulkBundle value
     * @param \StructType\BulkBundleInfoImpl $bulkBundle
     * @return \StructType\Bundles
     */
    public function setBulkBundle(\StructType\BulkBundleInfoImpl $bulkBundle = null)
    {
        $this->bulkBundle = $bulkBundle;
        return $this;
    }
    /**
     * Get bundle value
     * @return \StructType\BundleInfoImpl|null
     */
    public function getBundle()
    {
        return $this->bundle;
    }
    /**
     * Set bundle value
     * @param \StructType\BundleInfoImpl $bundle
     * @return \StructType\Bundles
     */
    public function setBundle(\StructType\BundleInfoImpl $bundle = null)
    {
        $this->bundle = $bundle;
        return $this;
    }
    /**
     * Get datBundle value
     * @return \StructType\DatBundleInfoImpl|null
     */
    public function getDatBundle()
    {
        return $this->datBundle;
    }
    /**
     * Set datBundle value
     * @param \StructType\DatBundleInfoImpl $datBundle
     * @return \StructType\Bundles
     */
    public function setDatBundle(\StructType\DatBundleInfoImpl $datBundle = null)
    {
        $this->datBundle = $datBundle;
        return $this;
    }
    /**
     * Get accountPoolBundle value
     * @return \StructType\AccountPoolingBundleInfoImpl|null
     */
    public function getAccountPoolBundle()
    {
        return $this->accountPoolBundle;
    }
    /**
     * Set accountPoolBundle value
     * @param \StructType\AccountPoolingBundleInfoImpl $accountPoolBundle
     * @return \StructType\Bundles
     */
    public function setAccountPoolBundle(\StructType\AccountPoolingBundleInfoImpl $accountPoolBundle = null)
    {
        $this->accountPoolBundle = $accountPoolBundle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Bundles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
