<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkDetails StructType
 * @subpackage Structs
 */
class BulkDetails extends AbstractStructBase
{
    /**
     * The bulkDeviceString
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $bulkDeviceString;
    /**
     * Constructor method for BulkDetails
     * @uses BulkDetails::setBulkDeviceString()
     * @param string[] $bulkDeviceString
     */
    public function __construct(array $bulkDeviceString = array())
    {
        $this
            ->setBulkDeviceString($bulkDeviceString);
    }
    /**
     * Get bulkDeviceString value
     * @return string[]|null
     */
    public function getBulkDeviceString()
    {
        return $this->bulkDeviceString;
    }
    /**
     * Set bulkDeviceString value
     * @throws \InvalidArgumentException
     * @param string[] $bulkDeviceString
     * @return \StructType\BulkDetails
     */
    public function setBulkDeviceString(array $bulkDeviceString = array())
    {
        foreach ($bulkDeviceString as $bulkDetailsBulkDeviceStringItem) {
            // validation for constraint: itemType
            if (!is_string($bulkDetailsBulkDeviceStringItem)) {
                throw new \InvalidArgumentException(sprintf('The bulkDeviceString property can only contain items of string, "%s" given', is_object($bulkDetailsBulkDeviceStringItem) ? get_class($bulkDetailsBulkDeviceStringItem) : gettype($bulkDetailsBulkDeviceStringItem)), __LINE__);
            }
        }
        $this->bulkDeviceString = $bulkDeviceString;
        return $this;
    }
    /**
     * Add item to bulkDeviceString value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BulkDetails
     */
    public function addToBulkDeviceString($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The bulkDeviceString property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->bulkDeviceString[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
