<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bulkActionSearchRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:bulkActionSearchRequestImpl
 * @subpackage Structs
 */
class BulkActionSearchRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The bulkRequestId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $bulkRequestId;
    /**
     * The wildcard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $wildcard;
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The isDeviceTransfer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDeviceTransfer;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestType;
    /**
     * Constructor method for bulkActionSearchRequestImpl
     * @uses BulkActionSearchRequestImpl::setBulkRequestId()
     * @uses BulkActionSearchRequestImpl::setWildcard()
     * @uses BulkActionSearchRequestImpl::setServiceType()
     * @uses BulkActionSearchRequestImpl::setIsDeviceTransfer()
     * @uses BulkActionSearchRequestImpl::setRequestType()
     * @param string $bulkRequestId
     * @param bool $wildcard
     * @param string $serviceType
     * @param bool $isDeviceTransfer
     * @param string $requestType
     */
    public function __construct($bulkRequestId = null, $wildcard = null, $serviceType = null, $isDeviceTransfer = null, $requestType = null)
    {
        $this
            ->setBulkRequestId($bulkRequestId)
            ->setWildcard($wildcard)
            ->setServiceType($serviceType)
            ->setIsDeviceTransfer($isDeviceTransfer)
            ->setRequestType($requestType);
    }
    /**
     * Get bulkRequestId value
     * @return string|null
     */
    public function getBulkRequestId()
    {
        return $this->bulkRequestId;
    }
    /**
     * Set bulkRequestId value
     * @param string $bulkRequestId
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public function setBulkRequestId($bulkRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($bulkRequestId) && !is_string($bulkRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bulkRequestId)), __LINE__);
        }
        $this->bulkRequestId = $bulkRequestId;
        return $this;
    }
    /**
     * Get wildcard value
     * @return bool|null
     */
    public function getWildcard()
    {
        return $this->wildcard;
    }
    /**
     * Set wildcard value
     * @param bool $wildcard
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public function setWildcard($wildcard = null)
    {
        $this->wildcard = $wildcard;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get isDeviceTransfer value
     * @return bool|null
     */
    public function getIsDeviceTransfer()
    {
        return $this->isDeviceTransfer;
    }
    /**
     * Set isDeviceTransfer value
     * @param bool $isDeviceTransfer
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public function setIsDeviceTransfer($isDeviceTransfer = null)
    {
        $this->isDeviceTransfer = $isDeviceTransfer;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @param string $requestType
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkActionSearchRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
