<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for availableDemoAndTrialCountsImpl StructType
 * @subpackage Structs
 */
class AvailableDemoAndTrialCountsImpl extends AbstractStructBase
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The datType
     * @var string
     */
    public $datType;
    /**
     * The availableCount
     * @var int
     */
    public $availableCount;
    /**
     * The activeCount
     * @var int
     */
    public $activeCount;
    /**
     * Constructor method for availableDemoAndTrialCountsImpl
     * @uses AvailableDemoAndTrialCountsImpl::setServiceType()
     * @uses AvailableDemoAndTrialCountsImpl::setDatType()
     * @uses AvailableDemoAndTrialCountsImpl::setAvailableCount()
     * @uses AvailableDemoAndTrialCountsImpl::setActiveCount()
     * @param string $serviceType
     * @param string $datType
     * @param int $availableCount
     * @param int $activeCount
     */
    public function __construct($serviceType = null, $datType = null, $availableCount = null, $activeCount = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setDatType($datType)
            ->setAvailableCount($availableCount)
            ->setActiveCount($activeCount);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\AvailableDemoAndTrialCountsImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get datType value
     * @return string|null
     */
    public function getDatType()
    {
        return $this->datType;
    }
    /**
     * Set datType value
     * @uses \EnumType\DatTypeEnum::valueIsValid()
     * @uses \EnumType\DatTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datType
     * @return \StructType\AvailableDemoAndTrialCountsImpl
     */
    public function setDatType($datType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatTypeEnum::valueIsValid($datType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $datType, implode(', ', \EnumType\DatTypeEnum::getValidValues())), __LINE__);
        }
        $this->datType = $datType;
        return $this;
    }
    /**
     * Get availableCount value
     * @return int|null
     */
    public function getAvailableCount()
    {
        return $this->availableCount;
    }
    /**
     * Set availableCount value
     * @param int $availableCount
     * @return \StructType\AvailableDemoAndTrialCountsImpl
     */
    public function setAvailableCount($availableCount = null)
    {
        // validation for constraint: int
        if (!is_null($availableCount) && !is_numeric($availableCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableCount)), __LINE__);
        }
        $this->availableCount = $availableCount;
        return $this;
    }
    /**
     * Get activeCount value
     * @return int|null
     */
    public function getActiveCount()
    {
        return $this->activeCount;
    }
    /**
     * Set activeCount value
     * @param int $activeCount
     * @return \StructType\AvailableDemoAndTrialCountsImpl
     */
    public function setActiveCount($activeCount = null)
    {
        // validation for constraint: int
        if (!is_null($activeCount) && !is_numeric($activeCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeCount)), __LINE__);
        }
        $this->activeCount = $activeCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableDemoAndTrialCountsImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
