<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for activities StructType
 * @subpackage Structs
 */
class Activities extends AbstractStructBase
{
    /**
     * The activity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VoucherActivityImpl[]
     */
    public $activity;
    /**
     * Constructor method for activities
     * @uses Activities::setActivity()
     * @param \StructType\VoucherActivityImpl[] $activity
     */
    public function __construct(array $activity = array())
    {
        $this
            ->setActivity($activity);
    }
    /**
     * Get activity value
     * @return \StructType\VoucherActivityImpl[]|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherActivityImpl[] $activity
     * @return \StructType\Activities
     */
    public function setActivity(array $activity = array())
    {
        foreach ($activity as $activitiesActivityItem) {
            // validation for constraint: itemType
            if (!$activitiesActivityItem instanceof \StructType\VoucherActivityImpl) {
                throw new \InvalidArgumentException(sprintf('The activity property can only contain items of \StructType\VoucherActivityImpl, "%s" given', is_object($activitiesActivityItem) ? get_class($activitiesActivityItem) : gettype($activitiesActivityItem)), __LINE__);
            }
        }
        $this->activity = $activity;
        return $this;
    }
    /**
     * Add item to activity value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherActivityImpl $item
     * @return \StructType\Activities
     */
    public function addToActivity(\StructType\VoucherActivityImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VoucherActivityImpl) {
            throw new \InvalidArgumentException(sprintf('The activity property can only contain items of \StructType\VoucherActivityImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->activity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Activities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
