<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for absPlanImpl StructType
 * @subpackage Structs
 */
abstract class AbsPlanImpl extends AbstractStructBase
{
    /**
     * The promo
     * @var string
     */
    public $promo;
    /**
     * The demoAndTrial
     * @var string
     */
    public $demoAndTrial;
    /**
     * The accountPoolingGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountPoolingGroup;
    /**
     * Constructor method for absPlanImpl
     * @uses AbsPlanImpl::setPromo()
     * @uses AbsPlanImpl::setDemoAndTrial()
     * @uses AbsPlanImpl::setAccountPoolingGroup()
     * @param string $promo
     * @param string $demoAndTrial
     * @param string $accountPoolingGroup
     */
    public function __construct($promo = null, $demoAndTrial = null, $accountPoolingGroup = null)
    {
        $this
            ->setPromo($promo)
            ->setDemoAndTrial($demoAndTrial)
            ->setAccountPoolingGroup($accountPoolingGroup);
    }
    /**
     * Get promo value
     * @return string|null
     */
    public function getPromo()
    {
        return $this->promo;
    }
    /**
     * Set promo value
     * @param string $promo
     * @return \StructType\AbsPlanImpl
     */
    public function setPromo($promo = null)
    {
        // validation for constraint: string
        if (!is_null($promo) && !is_string($promo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promo)), __LINE__);
        }
        $this->promo = $promo;
        return $this;
    }
    /**
     * Get demoAndTrial value
     * @return string|null
     */
    public function getDemoAndTrial()
    {
        return $this->demoAndTrial;
    }
    /**
     * Set demoAndTrial value
     * @param string $demoAndTrial
     * @return \StructType\AbsPlanImpl
     */
    public function setDemoAndTrial($demoAndTrial = null)
    {
        // validation for constraint: string
        if (!is_null($demoAndTrial) && !is_string($demoAndTrial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($demoAndTrial)), __LINE__);
        }
        $this->demoAndTrial = $demoAndTrial;
        return $this;
    }
    /**
     * Get accountPoolingGroup value
     * @return string|null
     */
    public function getAccountPoolingGroup()
    {
        return $this->accountPoolingGroup;
    }
    /**
     * Set accountPoolingGroup value
     * @param string $accountPoolingGroup
     * @return \StructType\AbsPlanImpl
     */
    public function setAccountPoolingGroup($accountPoolingGroup = null)
    {
        // validation for constraint: string
        if (!is_null($accountPoolingGroup) && !is_string($accountPoolingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountPoolingGroup)), __LINE__);
        }
        $this->accountPoolingGroup = $accountPoolingGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbsPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
