<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mm ServiceType
 * @subpackage Services
 */
class Mm extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named m2mImeiSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\M2MImeiSearchRequestImpl $request
     * @return \StructType\M2MImeiSearchResponseImpl|bool
     */
    public function m2mImeiSearch(\StructType\M2MImeiSearchRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->m2mImeiSearch($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\M2MImeiSearchResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
