<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grant ServiceType
 * @subpackage Services
 */
class Grant extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named grantRole
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrantRoleRequestImpl $request
     * @return \StructType\IwsResponseImpl|bool
     */
    public function grantRole(\StructType\GrantRoleRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->grantRole($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IwsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
