<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deactivate ServiceType
 * @subpackage Services
 */
class Deactivate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deactivateTelephonyScratchCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeactivateTelephonyScratchCardRequestImpl $request
     * @return \StructType\DeactivateTelephonyScratchCardResponseImpl|bool
     */
    public function deactivateTelephonyScratchCard(\StructType\DeactivateTelephonyScratchCardRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->deactivateTelephonyScratchCard($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeactivateTelephonyScratchCardResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
