<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createSubscriberOrganization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSubscriberOrgRequestImpl $request
     * @return \StructType\SubscriberOrgsResponseImpl|bool
     */
    public function createSubscriberOrganization(\StructType\CreateSubscriberOrgRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->createSubscriberOrganization($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createUserProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateUserProfileRequestImpl $request
     * @return \StructType\CreateUserProfileResponseImpl|bool
     */
    public function createUserProfile(\StructType\CreateUserProfileRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->createUserProfile($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateUserProfileResponseImpl|\StructType\SubscriberOrgsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
