<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Account ServiceType
 * @subpackage Services
 */
class Account extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named accountUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AccountUpdateRequestImpl $request
     * @return \StructType\AccountUpdateResponseImpl|bool
     */
    public function accountUpdate(\StructType\AccountUpdateRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->accountUpdate($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named accountSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AccountSearchRequestImpl $request
     * @return \StructType\AccountSearchResponseImpl|bool
     */
    public function accountSearch(\StructType\AccountSearchRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->accountSearch($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named accountUpdateDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AccountUpdateDevicesRequestImpl $request
     * @return \StructType\IwsResponseImpl|bool
     */
    public function accountUpdateDevices(\StructType\AccountUpdateDevicesRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->accountUpdateDevices($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AccountSearchResponseImpl|\StructType\AccountUpdateResponseImpl|\StructType\IwsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
