<?php

namespace EnumType;

/**
 * This class stands for subscriberBaseRptTypeEnum EnumType
 * @subpackage Enumerations
 */
class SubscriberBaseRptTypeEnum
{
    /**
     * Constant for value 'COMMERCIAL'
     * @return string 'COMMERCIAL'
     */
    const VALUE_COMMERCIAL = 'COMMERCIAL';
    /**
     * Constant for value 'DEMO'
     * @return string 'DEMO'
     */
    const VALUE_DEMO = 'DEMO';
    /**
     * Constant for value 'INTERNAL'
     * @return string 'INTERNAL'
     */
    const VALUE_INTERNAL = 'INTERNAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMERCIAL
     * @uses self::VALUE_DEMO
     * @uses self::VALUE_INTERNAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMERCIAL,
            self::VALUE_DEMO,
            self::VALUE_INTERNAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
