<?php

namespace EnumType;

/**
 * This class stands for submarketTypeEnum EnumType
 * @subpackage Enumerations
 */
class SubmarketTypeEnum
{
    /**
     * Constant for value 'PREPAID'
     * @return string 'PREPAID'
     */
    const VALUE_PREPAID = 'PREPAID';
    /**
     * Constant for value 'POSTPAID'
     * @return string 'POSTPAID'
     */
    const VALUE_POSTPAID = 'POSTPAID';
    /**
     * Constant for value 'CREW'
     * @return string 'CREW'
     */
    const VALUE_CREW = 'CREW';
    /**
     * Constant for value 'ATS'
     * @return string 'ATS'
     */
    const VALUE_ATS = 'ATS';
    /**
     * Constant for value 'SAFETY'
     * @return string 'SAFETY'
     */
    const VALUE_SAFETY = 'SAFETY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PREPAID
     * @uses self::VALUE_POSTPAID
     * @uses self::VALUE_CREW
     * @uses self::VALUE_ATS
     * @uses self::VALUE_SAFETY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PREPAID,
            self::VALUE_POSTPAID,
            self::VALUE_CREW,
            self::VALUE_ATS,
            self::VALUE_SAFETY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
