<?php

namespace EnumType;

/**
 * This class stands for searchOperatorEnum EnumType
 * @subpackage Enumerations
 */
class SearchOperatorEnum
{
    /**
     * Constant for value 'EQUAL_TO'
     * @return string 'EQUAL_TO'
     */
    const VALUE_EQUAL_TO = 'EQUAL_TO';
    /**
     * Constant for value 'LESS_THAN'
     * @return string 'LESS_THAN'
     */
    const VALUE_LESS_THAN = 'LESS_THAN';
    /**
     * Constant for value 'LESS_THAN_EQUAL_TO'
     * @return string 'LESS_THAN_EQUAL_TO'
     */
    const VALUE_LESS_THAN_EQUAL_TO = 'LESS_THAN_EQUAL_TO';
    /**
     * Constant for value 'GREATER_THAN'
     * @return string 'GREATER_THAN'
     */
    const VALUE_GREATER_THAN = 'GREATER_THAN';
    /**
     * Constant for value 'GREATER_THAN_EQUAL_TO'
     * @return string 'GREATER_THAN_EQUAL_TO'
     */
    const VALUE_GREATER_THAN_EQUAL_TO = 'GREATER_THAN_EQUAL_TO';
    /**
     * Constant for value 'LIKE'
     * @return string 'LIKE'
     */
    const VALUE_LIKE = 'LIKE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUAL_TO
     * @uses self::VALUE_LESS_THAN
     * @uses self::VALUE_LESS_THAN_EQUAL_TO
     * @uses self::VALUE_GREATER_THAN
     * @uses self::VALUE_GREATER_THAN_EQUAL_TO
     * @uses self::VALUE_LIKE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUAL_TO,
            self::VALUE_LESS_THAN,
            self::VALUE_LESS_THAN_EQUAL_TO,
            self::VALUE_GREATER_THAN,
            self::VALUE_GREATER_THAN_EQUAL_TO,
            self::VALUE_LIKE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
