<?php

namespace EnumType;

/**
 * This class stands for sbdDeleteDownloadResultTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdDeleteDownloadResultTypeEnum
{
    /**
     * Constant for value 'SUCCEEDED'
     * @return string 'SUCCEEDED'
     */
    const VALUE_SUCCEEDED = 'SUCCEEDED';
    /**
     * Constant for value 'FAILED_DID_NOT_FIND'
     * @return string 'FAILED_DID_NOT_FIND'
     */
    const VALUE_FAILED_DID_NOT_FIND = 'FAILED_DID_NOT_FIND';
    /**
     * Constant for value 'FAILED_INVALID_STATE'
     * @return string 'FAILED_INVALID_STATE'
     */
    const VALUE_FAILED_INVALID_STATE = 'FAILED_INVALID_STATE';
    /**
     * Constant for value 'STATUS_UNKNOWN'
     * @return string 'STATUS_UNKNOWN'
     */
    const VALUE_STATUS_UNKNOWN = 'STATUS_UNKNOWN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCEEDED
     * @uses self::VALUE_FAILED_DID_NOT_FIND
     * @uses self::VALUE_FAILED_INVALID_STATE
     * @uses self::VALUE_STATUS_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCEEDED,
            self::VALUE_FAILED_DID_NOT_FIND,
            self::VALUE_FAILED_INVALID_STATE,
            self::VALUE_STATUS_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
