<?php

namespace EnumType;

/**
 * This class stands for prepaidAccountTypeEnum EnumType
 * @subpackage Enumerations
 */
class PrepaidAccountTypeEnum
{
    /**
     * Constant for value 'PREPAID'
     * @return string 'PREPAID'
     */
    const VALUE_PREPAID = 'PREPAID';
    /**
     * Constant for value 'CREW'
     * @return string 'CREW'
     */
    const VALUE_CREW = 'CREW';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PREPAID
     * @uses self::VALUE_CREW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PREPAID,
            self::VALUE_CREW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
