<?php

namespace EnumType;

/**
 * This class stands for paymentModelTypeEnum EnumType
 * @subpackage Enumerations
 */
class PaymentModelTypeEnum
{
    /**
     * Constant for value 'PRE_PAID'
     * @return string 'PRE_PAID'
     */
    const VALUE_PRE_PAID = 'PRE_PAID';
    /**
     * Constant for value 'POST_PAID'
     * @return string 'POST_PAID'
     */
    const VALUE_POST_PAID = 'POST_PAID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRE_PAID
     * @uses self::VALUE_POST_PAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRE_PAID,
            self::VALUE_POST_PAID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
