<?php

namespace EnumType;

/**
 * This class stands for mtFilterRuleTypeEnum EnumType
 * @subpackage Enumerations
 */
class MtFilterRuleTypeEnum
{
    /**
     * Constant for value 'IP_ADDRESS'
     * @return string 'IP_ADDRESS'
     */
    const VALUE_IP_ADDRESS = 'IP_ADDRESS';
    /**
     * Constant for value 'EMAIL'
     * @return string 'EMAIL'
     */
    const VALUE_EMAIL = 'EMAIL';
    /**
     * Constant for value 'DOMAIN'
     * @return string 'DOMAIN'
     */
    const VALUE_DOMAIN = 'DOMAIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IP_ADDRESS
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_DOMAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IP_ADDRESS,
            self::VALUE_EMAIL,
            self::VALUE_DOMAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
