<?php

namespace EnumType;

/**
 * This class stands for modelServiceClassEnum EnumType
 * @subpackage Enumerations
 */
class ModelServiceClassEnum
{
    /**
     * Constant for value 'CERTUS_100'
     * @return string 'CERTUS_100'
     */
    const VALUE_CERTUS_100 = 'CERTUS_100';
    /**
     * Constant for value 'CERTUS_200'
     * @return string 'CERTUS_200'
     */
    const VALUE_CERTUS_200 = 'CERTUS_200';
    /**
     * Constant for value 'CERTUS_350'
     * @return string 'CERTUS_350'
     */
    const VALUE_CERTUS_350 = 'CERTUS_350';
    /**
     * Constant for value 'CERTUS_700'
     * @return string 'CERTUS_700'
     */
    const VALUE_CERTUS_700 = 'CERTUS_700';
    /**
     * Constant for value 'CERTUS_1500'
     * @return string 'CERTUS_1500'
     */
    const VALUE_CERTUS_1500 = 'CERTUS_1500';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTUS_100
     * @uses self::VALUE_CERTUS_200
     * @uses self::VALUE_CERTUS_350
     * @uses self::VALUE_CERTUS_700
     * @uses self::VALUE_CERTUS_1500
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTUS_100,
            self::VALUE_CERTUS_200,
            self::VALUE_CERTUS_350,
            self::VALUE_CERTUS_700,
            self::VALUE_CERTUS_1500,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
