<?php

namespace EnumType;

/**
 * This class stands for deviceNumberTypeEnum EnumType
 * @subpackage Enumerations
 */
class DeviceNumberTypeEnum
{
    /**
     * Constant for value 'MSISDNC'
     * @return string 'MSISDNC'
     */
    const VALUE_MSISDNC = 'MSISDNC';
    /**
     * Constant for value 'MSISDNB'
     * @return string 'MSISDNB'
     */
    const VALUE_MSISDNB = 'MSISDNB';
    /**
     * Constant for value 'MSISDN'
     * @return string 'MSISDN'
     */
    const VALUE_MSISDN = 'MSISDN';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'PLUS1'
     * @return string 'PLUS1'
     */
    const VALUE_PLUS_1 = 'PLUS1';
    /**
     * Constant for value 'PLUS7'
     * @return string 'PLUS7'
     */
    const VALUE_PLUS_7 = 'PLUS7';
    /**
     * Constant for value 'LOCALNUMBER'
     * @return string 'LOCALNUMBER'
     */
    const VALUE_LOCALNUMBER = 'LOCALNUMBER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MSISDNC
     * @uses self::VALUE_MSISDNB
     * @uses self::VALUE_MSISDN
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_PLUS_1
     * @uses self::VALUE_PLUS_7
     * @uses self::VALUE_LOCALNUMBER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MSISDNC,
            self::VALUE_MSISDNB,
            self::VALUE_MSISDN,
            self::VALUE_ISDNA,
            self::VALUE_PLUS_1,
            self::VALUE_PLUS_7,
            self::VALUE_LOCALNUMBER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
