<?php

namespace EnumType;

/**
 * This class stands for dataClassmarkEnum EnumType
 * @subpackage Enumerations
 */
class DataClassmarkEnum
{
    /**
     * Constant for value 'BBT1'
     * @return string 'BBT1'
     */
    const VALUE_BBT_1 = 'BBT1';
    /**
     * Constant for value 'SLBT1'
     * @return string 'SLBT1'
     */
    const VALUE_SLBT_1 = 'SLBT1';
    /**
     * Constant for value 'HHT1'
     * @return string 'HHT1'
     */
    const VALUE_HHT_1 = 'HHT1';
    /**
     * Constant for value 'BBT2'
     * @return string 'BBT2'
     */
    const VALUE_BBT_2 = 'BBT2';
    /**
     * Constant for value 'SLBT2'
     * @return string 'SLBT2'
     */
    const VALUE_SLBT_2 = 'SLBT2';
    /**
     * Constant for value 'SLBT3'
     * @return string 'SLBT3'
     */
    const VALUE_SLBT_3 = 'SLBT3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BBT_1
     * @uses self::VALUE_SLBT_1
     * @uses self::VALUE_HHT_1
     * @uses self::VALUE_BBT_2
     * @uses self::VALUE_SLBT_2
     * @uses self::VALUE_SLBT_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BBT_1,
            self::VALUE_SLBT_1,
            self::VALUE_HHT_1,
            self::VALUE_BBT_2,
            self::VALUE_SLBT_2,
            self::VALUE_SLBT_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
