<?php

namespace EnumType;

/**
 * This class stands for datTypeEnum EnumType
 * @subpackage Enumerations
 */
class DatTypeEnum
{
    /**
     * Constant for value 'TRIAL'
     * @return string 'TRIAL'
     */
    const VALUE_TRIAL = 'TRIAL';
    /**
     * Constant for value 'DEMO'
     * @return string 'DEMO'
     */
    const VALUE_DEMO = 'DEMO';
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRIAL
     * @uses self::VALUE_DEMO
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRIAL,
            self::VALUE_DEMO,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
