<?php

namespace EnumType;

/**
 * This class stands for contactTypeEnum EnumType
 * @subpackage Enumerations
 */
class ContactTypeEnum
{
    /**
     * Constant for value 'NO_CONTACT_TYPE'
     * @return string 'NO_CONTACT_TYPE'
     */
    const VALUE_NO_CONTACT_TYPE = 'NO_CONTACT_TYPE';
    /**
     * Constant for value 'USER_LOGIN_CONTACT_TYPE'
     * @return string 'USER_LOGIN_CONTACT_TYPE'
     */
    const VALUE_USER_LOGIN_CONTACT_TYPE = 'USER_LOGIN_CONTACT_TYPE';
    /**
     * Constant for value 'SP_NOTIFICATION_CONTACT_TYPE'
     * @return string 'SP_NOTIFICATION_CONTACT_TYPE'
     */
    const VALUE_SP_NOTIFICATION_CONTACT_TYPE = 'SP_NOTIFICATION_CONTACT_TYPE';
    /**
     * Constant for value 'SP_ACCOUNTS_PAYABLE_CONTACT_TYPE'
     * @return string 'SP_ACCOUNTS_PAYABLE_CONTACT_TYPE'
     */
    const VALUE_SP_ACCOUNTS_PAYABLE_CONTACT_TYPE = 'SP_ACCOUNTS_PAYABLE_CONTACT_TYPE';
    /**
     * Constant for value 'SP_CONTACT_TYPE'
     * @return string 'SP_CONTACT_TYPE'
     */
    const VALUE_SP_CONTACT_TYPE = 'SP_CONTACT_TYPE';
    /**
     * Constant for value 'GROUP_OWNER'
     * @return string 'GROUP_OWNER'
     */
    const VALUE_GROUP_OWNER = 'GROUP_OWNER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_CONTACT_TYPE
     * @uses self::VALUE_USER_LOGIN_CONTACT_TYPE
     * @uses self::VALUE_SP_NOTIFICATION_CONTACT_TYPE
     * @uses self::VALUE_SP_ACCOUNTS_PAYABLE_CONTACT_TYPE
     * @uses self::VALUE_SP_CONTACT_TYPE
     * @uses self::VALUE_GROUP_OWNER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_CONTACT_TYPE,
            self::VALUE_USER_LOGIN_CONTACT_TYPE,
            self::VALUE_SP_NOTIFICATION_CONTACT_TYPE,
            self::VALUE_SP_ACCOUNTS_PAYABLE_CONTACT_TYPE,
            self::VALUE_SP_CONTACT_TYPE,
            self::VALUE_GROUP_OWNER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
