<?php

namespace EnumType;

/**
 * This class stands for callStatusEnum EnumType
 * @subpackage Enumerations
 */
class CallStatusEnum
{
    /**
     * Constant for value 'IN_PROGRESS'
     * @return string 'IN_PROGRESS'
     */
    const VALUE_IN_PROGRESS = 'IN_PROGRESS';
    /**
     * Constant for value 'ENDED'
     * @return string 'ENDED'
     */
    const VALUE_ENDED = 'ENDED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_ENDED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IN_PROGRESS,
            self::VALUE_ENDED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
