<?php

namespace EnumType;

/**
 * This class stands for callDirectionEnum EnumType
 * @subpackage Enumerations
 */
class CallDirectionEnum
{
    /**
     * Constant for value 'OUTGOING'
     * @return string 'OUTGOING'
     */
    const VALUE_OUTGOING = 'OUTGOING';
    /**
     * Constant for value 'INCOMING'
     * @return string 'INCOMING'
     */
    const VALUE_INCOMING = 'INCOMING';
    /**
     * Constant for value 'EMERGENCY'
     * @return string 'EMERGENCY'
     */
    const VALUE_EMERGENCY = 'EMERGENCY';
    /**
     * Constant for value 'CALLFORWARD'
     * @return string 'CALLFORWARD'
     */
    const VALUE_CALLFORWARD = 'CALLFORWARD';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OUTGOING
     * @uses self::VALUE_INCOMING
     * @uses self::VALUE_EMERGENCY
     * @uses self::VALUE_CALLFORWARD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OUTGOING,
            self::VALUE_INCOMING,
            self::VALUE_EMERGENCY,
            self::VALUE_CALLFORWARD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
